/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class MetaMethodExpression
extends MethodExpression
implements Serializable {
    private static final long serialVersionUID = -2721042412903607760L;
    private static final Log log = LogFactory.getLog(MetaMethodExpression.class);
    private MethodExpression originalMethodExpression;

    public MetaMethodExpression(MethodExpression originalMethodExpression) {
        this.originalMethodExpression = originalMethodExpression;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaMethodExpression)) {
            return false;
        }
        MetaMethodExpression other = (MetaMethodExpression)obj;
        return this.originalMethodExpression.equals((Object)other.originalMethodExpression);
    }

    public int hashCode() {
        return this.originalMethodExpression.hashCode();
    }

    public String getExpressionString() {
        return this.originalMethodExpression.getExpressionString();
    }

    public boolean isLiteralText() {
        return this.originalMethodExpression.isLiteralText();
    }

    public MethodInfo getMethodInfo(ELContext context) {
        return null;
    }

    public Object invoke(ELContext context, Object[] params) {
        Object res = null;
        if (this.originalMethodExpression != null && (res = this.originalMethodExpression.invoke(context, params)) instanceof String) {
            String expression = (String)res;
            if (ComponentTagUtils.isValueReference(expression)) {
                FacesContext faces = FacesContext.getCurrentInstance();
                Application app = faces.getApplication();
                ExpressionFactory factory = app.getExpressionFactory();
                MethodExpression newMeth = factory.createMethodExpression(context, expression, Object.class, new Class[0]);
                try {
                    res = newMeth.invoke(context, null);
                }
                catch (Throwable t) {
                    if (t instanceof InvocationTargetException) {
                        throw new ELException(t.getCause());
                    }
                    throw new ELException(t);
                }
            } else {
                res = expression;
            }
        }
        return res;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.originalMethodExpression = (MethodExpression)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.originalMethodExpression);
    }
}

