/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.message;

import com.sun.faces.renderkit.html_basic.MessagesRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuxeo.runtime.api.Framework;

public class NXMessagesRenderer
extends MessagesRenderer {
    public static final String RENDERER_TYPE = "javax.faces.NXMessages";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        boolean mustRender = this.shouldWriteIdAttribute(component);
        UIMessages messages = (UIMessages)component;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = ((UIMessages)component).getFor();
        if (clientId == null && messages.isGlobalOnly()) {
            clientId = "";
        }
        Iterator messageIter = this.getMessageIter(context, clientId, component);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            if (mustRender) {
                if ("javax_faces_developmentstage_messages".equals(component.getId())) {
                    return;
                }
                writer.startElement("div", component);
                this.writeIdAttributeIfNecessary(context, writer, component);
                writer.endElement("div");
            }
            return;
        }
        boolean showDetail = messages.isShowDetail();
        while (messageIter.hasNext()) {
            FacesMessage curMessage = (FacesMessage)messageIter.next();
            if (curMessage.isRendered() && !messages.isRedisplay()) continue;
            curMessage.rendered();
            String summary = curMessage.getSummary();
            summary = null != summary ? summary : "";
            String detail = curMessage.getDetail();
            detail = null != detail ? detail : summary;
            String severityStyleClass = null;
            String errorType = "default";
            long timeout = 5L;
            if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severityStyleClass = (String)component.getAttributes().get("infoClass");
                errorType = "info";
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severityStyleClass = (String)component.getAttributes().get("warnClass");
                errorType = "warn";
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severityStyleClass = (String)component.getAttributes().get("errorClass");
                errorType = "error";
                timeout = 0L;
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severityStyleClass = (String)component.getAttributes().get("fatalClass");
                errorType = "fatal";
                timeout = 0L;
            }
            if (Framework.getProperty((String)"org.nuxeo.ecm.tester.name") != null) {
                timeout = 0L;
            }
            writer.startElement("script", (UIComponent)messages);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            String scriptContent = "jQuery(document).ready(function() {\n  jQuery.ambiance({\n    message: \"%s\",\n    title: \"%s\",\n    type: \"%s\",\n    className: \"%s\",\n    timeout: \"%d\"  })\n});\n";
            String formattedScriptContent = showDetail ? String.format(scriptContent, StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)detail)), StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)summary)), errorType, severityStyleClass, timeout) : String.format(scriptContent, "", StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)summary)), errorType, severityStyleClass, timeout);
            writer.writeText((Object)formattedScriptContent, null);
            writer.endElement("script");
        }
    }
}

