/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.htmleditor.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.platform.ui.web.htmleditor.api.HtmlEditorPluginService;
import org.nuxeo.ecm.platform.ui.web.htmleditor.service.HtmlEditorPluginDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class HtmlEditorPluginServiceImpl
extends DefaultComponent
implements HtmlEditorPluginService {
    public static final String PLUGINS_EXTENSION_POINT = "plugins";
    private Map<String, HtmlEditorPluginDescriptor> pluginsDescriptors;

    public void activate(ComponentContext context) throws Exception {
        this.pluginsDescriptors = new HashMap<String, HtmlEditorPluginDescriptor>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.pluginsDescriptors = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PLUGINS_EXTENSION_POINT.equals(extensionPoint)) {
            HtmlEditorPluginDescriptor descriptor = (HtmlEditorPluginDescriptor)contribution;
            if (descriptor.getRemove().booleanValue() && this.pluginsDescriptors.containsKey(descriptor.getPluginName())) {
                this.pluginsDescriptors.remove(descriptor.getPluginName());
            } else {
                this.pluginsDescriptors.put(descriptor.getPluginName(), descriptor);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PLUGINS_EXTENSION_POINT.equals(extensionPoint)) {
            HtmlEditorPluginDescriptor descriptor = (HtmlEditorPluginDescriptor)contribution;
            this.pluginsDescriptors.remove(descriptor.getPluginName());
        }
    }

    @Override
    public List<String> getPluginsName() {
        return new ArrayList<String>(this.pluginsDescriptors.keySet());
    }

    @Override
    public String getFormattedPluginsNames() {
        return StringUtils.join(this.getPluginsName(), (char)',');
    }

    public List<String> getToolbarsButtonsNames() {
        return new ArrayList<String>(this.pluginsDescriptors.keySet());
    }

    @Override
    public String getFormattedToolbarsButtonsNames() {
        return StringUtils.join(this.getToolbarsButtonsNames(), (char)',');
    }

    @Override
    public Map<String, String> getToolbarsButtons() {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> temp = new HashMap<String, ArrayList<String>>();
        for (HtmlEditorPluginDescriptor htmlEditorPluginDescriptor : this.pluginsDescriptors.values()) {
            ArrayList<String> buttonsList = (ArrayList<String>)temp.get(htmlEditorPluginDescriptor.getToolbarName());
            if (buttonsList == null) {
                buttonsList = new ArrayList<String>();
            }
            buttonsList.add(htmlEditorPluginDescriptor.getPluginButtonName());
            temp.put(htmlEditorPluginDescriptor.getToolbarName(), buttonsList);
        }
        for (Map.Entry entry : temp.entrySet()) {
            result.put((String)entry.getKey(), StringUtils.join((List)((List)entry.getValue()), (char)','));
        }
        return result;
    }
}

