/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.adapter;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.impl.AbstractVirtualFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.runtime.api.Framework;

public class SharedSyncRootParentFolderItem
extends AbstractVirtualFolderItem {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SharedSyncRootParentFolderItem.class);

    public SharedSyncRootParentFolderItem(String factoryName, Principal principal, String parentId, String parentPath, String folderName) throws ClientException {
        super(factoryName, principal, parentId, parentPath, folderName);
    }

    protected SharedSyncRootParentFolderItem() {
    }

    @Override
    public List<FileSystemItem> getChildren() throws ClientException {
        ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>();
        Map<String, SynchronizationRoots> syncRootsByRepo = ((NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class)).getSynchronizationRoots(this.principal);
        for (String repositoryName : syncRootsByRepo.keySet()) {
            CoreSession session = this.getSession(repositoryName);
            Set<IdRef> syncRootRefs = syncRootsByRepo.get(repositoryName).getRefs();
            for (IdRef idRef : syncRootRefs) {
                if (!session.hasPermission((DocumentRef)idRef, "Read")) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("User %s has no READ access on synchronization root %s, not including it in children.", session.getPrincipal().getName(), idRef));
                    continue;
                }
                DocumentModel doc = session.getDocument((DocumentRef)idRef);
                if (session.getPrincipal().getName().equals(doc.getPropertyValue("dc:creator"))) continue;
                FileSystemItem child = this.getFileSystemItemAdapterService().getFileSystemItem(doc, this, false, false, false);
                if (child == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Synchronization root %s cannot be adapted as a FileSystemItem, maybe because user %s doesn't have the required permission on it (default required permission is ReadWrite). Not including it in children.", idRef, session.getPrincipal().getName()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Including synchronization root %s in children.", idRef));
                }
                children.add(child);
            }
        }
        Collections.sort(children);
        return children;
    }
}

