/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.ObjectObjectMap;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.lucene.all.AllEntries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public class ParseContext {
    private final DocumentMapper docMapper;
    private final DocumentMapperParser docMapperParser;
    private final ContentPath path;
    private XContentParser parser;
    private Document document;
    private List<Document> documents = Lists.newArrayList();
    private Analyzer analyzer;
    private final String index;
    @Nullable
    private final Settings indexSettings;
    private SourceToParse sourceToParse;
    private BytesReference source;
    private String id;
    private DocumentMapper.ParseListener listener;
    private Field uid;
    private Field version;
    private StringBuilder stringBuilder = new StringBuilder();
    private Map<String, String> ignoredValues = new HashMap<String, String>();
    private boolean mappingsModified = false;
    private boolean withinNewMapper = false;
    private boolean withinCopyTo = false;
    private boolean withinMultiFields = false;
    private boolean externalValueSet;
    private Object externalValue;
    private AllEntries allEntries = new AllEntries();
    private float docBoost = 1.0f;

    public ParseContext(String index, @Nullable Settings indexSettings, DocumentMapperParser docMapperParser, DocumentMapper docMapper, ContentPath path) {
        this.index = index;
        this.indexSettings = indexSettings;
        this.docMapper = docMapper;
        this.docMapperParser = docMapperParser;
        this.path = path;
    }

    public void reset(XContentParser parser, Document document, SourceToParse source, DocumentMapper.ParseListener listener) {
        this.parser = parser;
        this.document = document;
        if (document != null) {
            this.documents = Lists.newArrayList();
            this.documents.add(document);
        } else {
            this.documents = null;
        }
        this.analyzer = null;
        this.uid = null;
        this.version = null;
        this.id = null;
        this.sourceToParse = source;
        this.source = source == null ? null : this.sourceToParse.source();
        this.path.reset();
        this.mappingsModified = false;
        this.withinNewMapper = false;
        this.listener = listener == null ? DocumentMapper.ParseListener.EMPTY : listener;
        this.allEntries = new AllEntries();
        this.ignoredValues.clear();
        this.docBoost = 1.0f;
    }

    public boolean flyweight() {
        return this.sourceToParse.flyweight();
    }

    public DocumentMapperParser docMapperParser() {
        return this.docMapperParser;
    }

    public boolean mappingsModified() {
        return this.mappingsModified;
    }

    public void setMappingsModified() {
        this.mappingsModified = true;
    }

    public void setWithinNewMapper() {
        this.withinNewMapper = true;
    }

    public void clearWithinNewMapper() {
        this.withinNewMapper = false;
    }

    public boolean isWithinNewMapper() {
        return this.withinNewMapper;
    }

    public void setWithinCopyTo() {
        this.withinCopyTo = true;
    }

    public void clearWithinCopyTo() {
        this.withinCopyTo = false;
    }

    public boolean isWithinCopyTo() {
        return this.withinCopyTo;
    }

    public void setWithinMultiFields() {
        this.withinMultiFields = true;
    }

    public void clearWithinMultiFields() {
        this.withinMultiFields = false;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Settings indexSettings() {
        return this.indexSettings;
    }

    public String type() {
        return this.sourceToParse.type();
    }

    public SourceToParse sourceToParse() {
        return this.sourceToParse;
    }

    public BytesReference source() {
        return this.source;
    }

    public void source(BytesReference source) {
        this.source = source;
    }

    public ContentPath path() {
        return this.path;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public DocumentMapper.ParseListener listener() {
        return this.listener;
    }

    public Document rootDoc() {
        return this.documents.get(0);
    }

    public List<Document> docs() {
        return this.documents;
    }

    public Document doc() {
        return this.document;
    }

    public void addDoc(Document doc) {
        this.documents.add(doc);
    }

    public Document switchDoc(Document doc) {
        Document prev = this.document;
        this.document = doc;
        return prev;
    }

    public RootObjectMapper root() {
        return this.docMapper.root();
    }

    public DocumentMapper docMapper() {
        return this.docMapper;
    }

    public AnalysisService analysisService() {
        return this.docMapperParser.analysisService;
    }

    public String id() {
        return this.id;
    }

    public void ignoredValue(String indexName, String value) {
        this.ignoredValues.put(indexName, value);
    }

    public String ignoredValue(String indexName) {
        return this.ignoredValues.get(indexName);
    }

    public void id(String id) {
        this.id = id;
    }

    public Field uid() {
        return this.uid;
    }

    public void uid(Field uid) {
        this.uid = uid;
    }

    public Field version() {
        return this.version;
    }

    public void version(Field version) {
        this.version = version;
    }

    public boolean includeInAll(Boolean includeInAll, FieldMapper mapper) {
        return this.includeInAll(includeInAll, mapper.fieldType().indexed());
    }

    private boolean includeInAll(Boolean specificIncludeInAll, boolean indexed) {
        if (this.withinCopyTo) {
            return false;
        }
        if (this.withinMultiFields) {
            return false;
        }
        if (!this.docMapper.allFieldMapper().enabled()) {
            return false;
        }
        if (specificIncludeInAll == null) {
            return indexed;
        }
        return specificIncludeInAll;
    }

    public AllEntries allEntries() {
        return this.allEntries;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public void analyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void externalValue(Object externalValue) {
        this.externalValueSet = true;
        this.externalValue = externalValue;
    }

    public boolean externalValueSet() {
        return this.externalValueSet;
    }

    public Object externalValue() {
        this.externalValueSet = false;
        return this.externalValue;
    }

    public <T> T parseExternalValue(Class<T> clazz) {
        if (!this.externalValueSet() || this.externalValue() == null) {
            return null;
        }
        if (!clazz.isInstance(this.externalValue())) {
            throw new ElasticsearchIllegalArgumentException("illegal external value class [" + this.externalValue().getClass().getName() + "]. Should be " + clazz.getName());
        }
        return (T)this.externalValue();
    }

    public float docBoost() {
        return this.docBoost;
    }

    public void docBoost(float docBoost) {
        this.docBoost = docBoost;
    }

    public StringBuilder stringBuilder() {
        this.stringBuilder.setLength(0);
        return this.stringBuilder;
    }

    public static class Document
    implements Iterable<IndexableField> {
        private final List<IndexableField> fields = Lists.newArrayList();
        private ObjectObjectMap<Object, IndexableField> keyedFields;

        @Override
        public Iterator<IndexableField> iterator() {
            return this.fields.iterator();
        }

        public List<IndexableField> getFields() {
            return this.fields;
        }

        public void add(IndexableField field) {
            this.fields.add(field);
        }

        public void addWithKey(Object key, IndexableField field) {
            if (this.keyedFields == null) {
                this.keyedFields = new ObjectObjectOpenHashMap<Object, IndexableField>();
            } else if (this.keyedFields.containsKey(key)) {
                throw new ElasticsearchIllegalStateException("Only one field can be stored per key");
            }
            this.keyedFields.put(key, field);
            this.add(field);
        }

        public IndexableField getByKey(Object key) {
            return this.keyedFields == null ? null : this.keyedFields.get(key);
        }

        public IndexableField[] getFields(String name) {
            ArrayList<IndexableField> f = new ArrayList<IndexableField>();
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                f.add(field);
            }
            return f.toArray(new IndexableField[f.size()]);
        }

        public IndexableField getField(String name) {
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                return field;
            }
            return null;
        }

        public String get(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.stringValue() == null) continue;
                return f.stringValue();
            }
            return null;
        }

        public BytesRef getBinaryValue(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.binaryValue() == null) continue;
                return f.binaryValue();
            }
            return null;
        }
    }
}

