/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.ttl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fieldvisitor.UidAndRoutingFieldsVisitor;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.TTLFieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.settings.NodeSettingsService;

public class IndicesTTLService
extends AbstractLifecycleComponent<IndicesTTLService> {
    public static final String INDICES_TTL_INTERVAL = "indices.ttl.interval";
    public static final String INDEX_TTL_DISABLE_PURGE = "index.ttl.disable_purge";
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final TransportBulkAction bulkAction;
    private final int bulkSize;
    private PurgerThread purgerThread;

    @Inject
    public IndicesTTLService(Settings settings, ClusterService clusterService, IndicesService indicesService, NodeSettingsService nodeSettingsService, TransportBulkAction bulkAction) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        TimeValue interval = this.componentSettings.getAsTime("interval", TimeValue.timeValueSeconds(60L));
        this.bulkAction = bulkAction;
        this.bulkSize = this.componentSettings.getAsInt("bulk_size", (Integer)10000);
        this.purgerThread = new PurgerThread(EsExecutors.threadName(settings, "[ttl_expire]"), interval);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.purgerThread.start();
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        try {
            this.purgerThread.shutdown();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeShards(List<IndexShard> shardsToPurge) {
        for (IndexShard shardToPurge : shardsToPurge) {
            NumericRangeQuery query = NumericRangeQuery.newLongRange((String)"_ttl", null, (Long)System.currentTimeMillis(), (boolean)false, (boolean)true);
            Engine.Searcher searcher = shardToPurge.acquireSearcher("indices_ttl");
            try {
                this.logger.debug("[{}][{}] purging shard", shardToPurge.routingEntry().index(), shardToPurge.routingEntry().id());
                ExpiredDocsCollector expiredDocsCollector = new ExpiredDocsCollector();
                searcher.searcher().search((Query)query, (Collector)expiredDocsCollector);
                List<DocToPurge> docsToPurge = expiredDocsCollector.getDocsToPurge();
                BulkRequest bulkRequest = new BulkRequest();
                for (DocToPurge docToPurge : docsToPurge) {
                    bulkRequest.add(((DeleteRequest)new DeleteRequest().index(shardToPurge.routingEntry().index())).type(docToPurge.type).id(docToPurge.id).version(docToPurge.version).routing(docToPurge.routing));
                    bulkRequest = this.processBulkIfNeeded(bulkRequest, false);
                }
                this.processBulkIfNeeded(bulkRequest, true);
            }
            catch (Exception e) {
                this.logger.warn("failed to purge", e, new Object[0]);
            }
            finally {
                searcher.release();
            }
        }
    }

    private BulkRequest processBulkIfNeeded(BulkRequest bulkRequest, boolean force) {
        if (force && bulkRequest.numberOfActions() > 0 || bulkRequest.numberOfActions() >= this.bulkSize) {
            try {
                this.bulkAction.executeBulk(bulkRequest, new ActionListener<BulkResponse>(){

                    @Override
                    public void onResponse(BulkResponse bulkResponse) {
                        IndicesTTLService.this.logger.trace("bulk took " + bulkResponse.getTookInMillis() + "ms", new Object[0]);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        IndicesTTLService.this.logger.warn("failed to execute bulk", new Object[0]);
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn("failed to process bulk", e, new Object[0]);
            }
            bulkRequest = new BulkRequest();
        }
        return bulkRequest;
    }

    private static final class Notifier {
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private volatile TimeValue timeout;

        public Notifier(TimeValue timeout) {
            assert (timeout != null);
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() {
            this.lock.lock();
            try {
                this.condition.await(this.timeout.millis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void setTimeout(TimeValue timeout) {
            assert (timeout != null);
            this.timeout = timeout;
            this.doNotify();
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doNotify() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue currentInterval = IndicesTTLService.this.purgerThread.getInterval();
            TimeValue interval = settings.getAsTime(IndicesTTLService.INDICES_TTL_INTERVAL, currentInterval);
            if (!interval.equals(currentInterval)) {
                IndicesTTLService.this.logger.info("updating indices.ttl.interval from [{}] to [{}]", currentInterval, interval);
                IndicesTTLService.this.purgerThread.resetInterval(interval);
            }
        }
    }

    private class ExpiredDocsCollector
    extends Collector {
        private AtomicReaderContext context;
        private List<DocToPurge> docsToPurge = new ArrayList<DocToPurge>();

        public void setScorer(Scorer scorer) {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public void collect(int doc) {
            try {
                UidAndRoutingFieldsVisitor fieldsVisitor = new UidAndRoutingFieldsVisitor();
                this.context.reader().document(doc, (StoredFieldVisitor)fieldsVisitor);
                Uid uid = fieldsVisitor.uid();
                long version = Versions.loadVersion((IndexReader)this.context.reader(), new Term("_uid", uid.toBytesRef()));
                this.docsToPurge.add(new DocToPurge(uid.type(), uid.id(), version, fieldsVisitor.routing()));
            }
            catch (Exception e) {
                IndicesTTLService.this.logger.trace("failed to collect doc", e, new Object[0]);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.context = context;
        }

        public List<DocToPurge> getDocsToPurge() {
            return this.docsToPurge;
        }
    }

    private static class DocToPurge {
        public final String type;
        public final String id;
        public final long version;
        public final String routing;

        public DocToPurge(String type, String id, long version, String routing) {
            this.type = type;
            this.id = id;
            this.version = version;
            this.routing = routing;
        }
    }

    private class PurgerThread
    extends Thread {
        private final AtomicBoolean running;
        private final Notifier notifier;
        private final CountDownLatch shutdownLatch;

        public PurgerThread(String name, TimeValue interval) {
            super(name);
            this.running = new AtomicBoolean(true);
            this.shutdownLatch = new CountDownLatch(1);
            this.setDaemon(true);
            this.notifier = new Notifier(interval);
        }

        public void shutdown() throws InterruptedException {
            if (this.running.compareAndSet(true, false)) {
                this.notifier.doNotify();
                this.shutdownLatch.await();
            }
        }

        public void resetInterval(TimeValue interval) {
            this.notifier.setTimeout(interval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.running.get()) {
                    block6: {
                        try {
                            List<IndexShard> shardsToPurge = this.getShardsToPurge();
                            IndicesTTLService.this.purgeShards(shardsToPurge);
                        }
                        catch (Throwable e) {
                            if (!this.running.get()) break block6;
                            IndicesTTLService.this.logger.warn("failed to execute ttl purge", e, new Object[0]);
                        }
                    }
                    if (!this.running.get()) continue;
                    this.notifier.await();
                }
            }
            finally {
                this.shutdownLatch.countDown();
            }
        }

        private List<IndexShard> getShardsToPurge() {
            ArrayList<IndexShard> shardsToPurge = new ArrayList<IndexShard>();
            MetaData metaData = IndicesTTLService.this.clusterService.state().metaData();
            for (IndexService indexService : IndicesTTLService.this.indicesService) {
                FieldMappers ttlFieldMappers;
                boolean disablePurge;
                IndexMetaData indexMetaData = metaData.index(indexService.index().name());
                if (indexMetaData == null || (disablePurge = indexMetaData.settings().getAsBoolean(IndicesTTLService.INDEX_TTL_DISABLE_PURGE, (Boolean)false).booleanValue()) || (ttlFieldMappers = indexService.mapperService().name("_ttl")) == null) continue;
                boolean hasTTLEnabled = false;
                for (FieldMapper ttlFieldMapper : ttlFieldMappers) {
                    if (!((TTLFieldMapper)ttlFieldMapper).enabled()) continue;
                    hasTTLEnabled = true;
                    break;
                }
                if (!hasTTLEnabled) continue;
                for (IndexShard indexShard : indexService) {
                    if (indexShard.state() != IndexShardState.STARTED || !indexShard.routingEntry().primary() || !indexShard.routingEntry().started()) continue;
                    shardsToPurge.add(indexShard);
                }
            }
            return shardsToPurge;
        }

        public TimeValue getInterval() {
            return this.notifier.getTimeout();
        }
    }
}

