/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ScriptValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueParser;

public class ValuesSourceConfig<VS extends ValuesSource> {
    final Class<VS> valueSourceType;
    FieldContext fieldContext;
    SearchScript script;
    ValueFormatter formatter;
    ValueParser parser;
    ScriptValueType scriptValueType;
    boolean unmapped = false;
    boolean needsHashes = false;
    boolean ensureUnique = false;
    boolean ensureSorted = false;

    public ValuesSourceConfig(Class<VS> valueSourceType) {
        this.valueSourceType = valueSourceType;
    }

    public Class<VS> valueSourceType() {
        return this.valueSourceType;
    }

    public FieldContext fieldContext() {
        return this.fieldContext;
    }

    public boolean unmapped() {
        return this.unmapped;
    }

    public boolean valid() {
        return this.fieldContext != null || this.script != null || this.unmapped;
    }

    public ValuesSourceConfig<VS> fieldContext(FieldContext fieldContext) {
        this.fieldContext = fieldContext;
        return this;
    }

    public ValuesSourceConfig<VS> script(SearchScript script) {
        this.script = script;
        return this;
    }

    public ValuesSourceConfig<VS> formatter(ValueFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public ValueFormatter formatter() {
        return this.formatter;
    }

    public ValuesSourceConfig<VS> parser(ValueParser parser) {
        this.parser = parser;
        return this;
    }

    public ValueParser parser() {
        return this.parser;
    }

    public ValuesSourceConfig<VS> scriptValueType(ScriptValueType scriptValueType) {
        this.scriptValueType = scriptValueType;
        return this;
    }

    public ScriptValueType scriptValueType() {
        return this.scriptValueType;
    }

    public ValuesSourceConfig<VS> unmapped(boolean unmapped) {
        this.unmapped = unmapped;
        return this;
    }

    public ValuesSourceConfig<VS> needsHashes(boolean needsHashes) {
        this.needsHashes = needsHashes;
        return this;
    }

    public ValuesSourceConfig<VS> ensureUnique(boolean unique) {
        this.ensureUnique = unique;
        return this;
    }

    public ValuesSourceConfig<VS> ensureSorted(boolean sorted) {
        this.ensureSorted = sorted;
        return this;
    }
}

