/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.partial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.partial.PartialFieldsContext;
import org.elasticsearch.search.fetch.partial.PartialFieldsParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.SearchContext;

public class PartialFieldsFetchSubPhase
implements FetchSubPhase {
    @Inject
    public PartialFieldsFetchSubPhase() {
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, PartialFieldsParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("partial_fields", new PartialFieldsParseElement()).put("partialFields", new PartialFieldsParseElement());
        return parseElements.build();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticsearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.hasPartialFields();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticsearchException {
        for (PartialFieldsContext.PartialField field : context.partialFields().fields()) {
            SearchHitField hitField;
            Object value = context.lookup().source().filter(field.includes(), field.excludes());
            if (hitContext.hit().fieldsOrNull() == null) {
                hitContext.hit().fields(new HashMap<String, SearchHitField>(2));
            }
            if ((hitField = hitContext.hit().fields().get(field.name())) == null) {
                hitField = new InternalSearchHitField(field.name(), new ArrayList<Object>(2));
                hitContext.hit().fields().put(field.name(), hitField);
            }
            hitField.values().add(value);
        }
    }
}

