/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;

public class ResourceTemplateLoader
implements TemplateLoader {
    protected ResourceLocator locator;
    protected final MyURLTemplateLoader urlLoader;
    protected final MyFileTemplateLoader fileLoader;

    public ResourceTemplateLoader(ResourceLocator locator) {
        this.locator = locator;
        this.urlLoader = new MyURLTemplateLoader();
        this.fileLoader = new MyFileTemplateLoader();
    }

    public void setLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    public ResourceLocator getLocator() {
        return this.locator;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        if (templateSource instanceof File) {
            this.fileLoader.closeTemplateSource(templateSource);
        } else if (templateSource instanceof URL) {
            this.urlLoader.closeTemplateSource(templateSource);
        }
    }

    public Object findTemplateSource(String name) throws IOException {
        if (name.startsWith("fs://")) {
            name = name.substring(5);
        } else if (name.contains(":/")) {
            return this.urlLoader.findTemplateSource(name);
        }
        Object obj = this.fileLoader.findTemplateSource(name);
        if (obj != null) {
            return obj;
        }
        return this.urlLoader.findTemplateSource(name);
    }

    public long getLastModified(Object templateSource) {
        if (templateSource instanceof File) {
            return this.fileLoader.getLastModified(templateSource);
        }
        return this.urlLoader.getLastModified(templateSource);
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource instanceof File) {
            return this.fileLoader.getReader(templateSource, encoding);
        }
        return this.urlLoader.getReader(templateSource, encoding);
    }

    class MyFileTemplateLoader
    implements TemplateLoader {
        MyFileTemplateLoader() {
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }

        public Object findTemplateSource(String name) throws IOException {
            File file;
            if (ResourceTemplateLoader.this.locator != null && (file = ResourceTemplateLoader.this.locator.getResourceFile(name)) != null) {
                return file.getCanonicalFile();
            }
            try {
                file = new File(name).getCanonicalFile();
                if (file.isFile()) {
                    return file;
                }
            }
            catch (IOException e) {
                return null;
            }
            return null;
        }

        public long getLastModified(Object templateSource) {
            try {
                return ((File)templateSource).lastModified();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("templateSource is a: " + templateSource.getClass().getName());
            }
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            try {
                return new InputStreamReader((InputStream)new FileInputStream((File)templateSource), encoding);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("templateSource is a: " + templateSource.getClass().getName());
            }
        }
    }

    class MyURLTemplateLoader
    extends URLTemplateLoader {
        MyURLTemplateLoader() {
        }

        protected URL getURL(String arg0) {
            if (ResourceTemplateLoader.this.locator != null) {
                return ResourceTemplateLoader.this.locator.getResourceURL(arg0);
            }
            try {
                return new URL(arg0);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }
}

