/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;

public class VersionIncEditOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private VersioningActions defaultVersioningAction;
    private final List<VersioningActions> options = new ArrayList<VersioningActions>();

    public VersioningActions getDefaultVersioningAction() {
        if (this.defaultVersioningAction == null) {
            return VersioningActions.ACTION_NO_INCREMENT;
        }
        return this.defaultVersioningAction;
    }

    public void setDefaultVersioningAction(VersioningActions defaultVersioningAction) {
        this.defaultVersioningAction = defaultVersioningAction;
    }

    public void addOption(VersioningActions option) {
        this.options.add(option);
    }

    public List<VersioningActions> getOptions() {
        return this.options;
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public Map<String, String> getOptionsForDisplay() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.options != null) {
            for (VersioningActions option : this.options) {
                String label = "label.versioning.option." + option.toString();
                map.put(option.name(), label);
            }
        }
        return map;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.options + ')';
    }
}

