/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.http.HttpUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieUtils {
    public static String format(List<Cookie> cookies) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i == 0) {
                if (cookie.getVersion() > 0) {
                    sb.append("$Version=\"").append(cookie.getVersion()).append("\"; ");
                }
            } else {
                sb.append("; ");
            }
            CookieUtils.format(cookie, (Appendable)sb);
        }
        return sb.toString();
    }

    public static String format(CookieSetting cookieSetting) {
        StringBuilder sb = new StringBuilder();
        try {
            CookieUtils.format(cookieSetting, (Appendable)sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void format(CookieSetting cookieSetting, Appendable destination) throws IOException {
        String comment;
        int maxAge;
        String path;
        String name = cookieSetting.getName();
        String value = cookieSetting.getValue();
        int version = cookieSetting.getVersion();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Can't write cookie. Invalid name detected");
        }
        destination.append(name).append('=');
        if (value != null && value.length() > 0) {
            CookieUtils.appendValue(value, version, destination);
        }
        if (version > 0) {
            destination.append("; Version=");
            CookieUtils.appendValue(Integer.toString(version), version, destination);
        }
        if ((path = cookieSetting.getPath()) != null && path.length() > 0) {
            destination.append("; Path=");
            if (version == 0) {
                destination.append(path);
            } else {
                HttpUtils.appendQuote(path, destination);
            }
        }
        if ((maxAge = cookieSetting.getMaxAge()) >= 0) {
            if (version == 0) {
                long currentTime = System.currentTimeMillis();
                long maxTime = (long)maxAge * 1000L;
                long expiresTime = currentTime + maxTime;
                Date expires = new Date(expiresTime);
                destination.append("; Expires=");
                CookieUtils.appendValue(DateUtils.format(expires, DateUtils.FORMAT_RFC_1036.get(0)), version, destination);
            } else {
                destination.append("; Max-Age=");
                CookieUtils.appendValue(Integer.toString(cookieSetting.getMaxAge()), version, destination);
            }
        } else if (maxAge == -1 && version > 0) {
            destination.append("; Discard");
        }
        String domain = cookieSetting.getDomain();
        if (domain != null && domain.length() > 0) {
            destination.append("; Domain=");
            CookieUtils.appendValue(domain.toLowerCase(), version, destination);
        }
        if (cookieSetting.isSecure()) {
            destination.append("; Secure");
        }
        if (version > 0 && (comment = cookieSetting.getComment()) != null && comment.length() > 0) {
            destination.append("; Comment=");
            CookieUtils.appendValue(comment, version, destination);
        }
    }

    public static String format(Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        CookieUtils.format(cookie, (Appendable)sb);
        return sb.toString();
    }

    public static void format(Cookie cookie, Appendable destination) {
        String name = cookie.getName();
        String value = cookie.getValue();
        int version = cookie.getVersion();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Can't write cookie. Invalid name detected");
        }
        try {
            CookieUtils.appendValue(name, 0, destination).append('=');
            if (value != null && value.length() > 0) {
                CookieUtils.appendValue(value, version, destination);
            }
            if (version > 0) {
                String domain;
                String path = cookie.getPath();
                if (path != null && path.length() > 0) {
                    destination.append("; $Path=");
                    HttpUtils.appendQuote(path, destination);
                }
                if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
                    destination.append("; $Domain=");
                    HttpUtils.appendQuote(domain, destination);
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static Appendable appendValue(CharSequence value, int version, Appendable destination) throws IOException {
        if (version == 0) {
            destination.append(((Object)value).toString());
        } else {
            HttpUtils.appendQuote(value, destination);
        }
        return destination;
    }

    public static void getCookies(List<Cookie> source, Map<String, Cookie> destination) {
        for (Cookie cookie : source) {
            if (!destination.containsKey(cookie.getName())) continue;
            destination.put(cookie.getName(), cookie);
        }
    }
}

