/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.component;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.facelets.impl.DefaultFaceletFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.view.facelets.Facelet;

public class UIFragment
extends UIOutput {
    final String templateEngine = "jsf-facelets";
    private String uid;
    private String engine;
    private String mode;

    public void encodeAll(FacesContext context) throws IOException {
        Map attributes = this.getAttributes();
        this.uid = (String)attributes.get("uid");
        this.engine = (String)attributes.get("engine");
        this.mode = (String)attributes.get("mode");
        ResponseWriter response = context.getResponseWriter();
        UIViewRoot oldViewRoot = context.getViewRoot();
        StringWriter stringWriter = new StringWriter();
        context.setResponseWriter(response.cloneWithWriter((Writer)stringWriter));
        UIViewRoot viewRoot = new UIViewRoot();
        viewRoot.setRendererType(oldViewRoot.getRendererType());
        viewRoot.setRenderKitId(oldViewRoot.getRenderKitId());
        viewRoot.setViewId(oldViewRoot.getViewId());
        viewRoot.setLocale(oldViewRoot.getLocale());
        context.setViewRoot(viewRoot);
        String faceletId = String.format("nxtheme://element/%s/%s/%s/%s", this.engine, this.mode, "jsf-facelets", this.uid);
        ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
        DefaultFaceletFactory faceletFactory = associate.getFaceletFactory();
        Facelet facelet = faceletFactory.getFacelet(context, faceletId);
        facelet.apply(context, (UIComponent)viewRoot);
        UIFragment.renderChildren(context, (UIComponent)viewRoot);
        response.write(stringWriter.getBuffer().toString());
        context.setResponseWriter(response);
        context.setViewRoot(oldViewRoot);
    }

    public boolean isTransient() {
        return true;
    }

    private static void renderChildren(FacesContext context, UIComponent component) throws IOException {
        List children = component.getChildren();
        for (Object child : children) {
            UIFragment.renderChild(context, (UIComponent)child);
        }
    }

    private static void renderChild(FacesContext context, UIComponent child) throws IOException {
        if (child.isRendered()) {
            child.encodeBegin(context);
            if (child.getRendersChildren()) {
                child.encodeChildren(context);
            } else {
                UIFragment.renderChildren(context, child);
            }
            child.encodeEnd(context);
        }
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}

