/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.automation;

import fr.toutatice.ecm.elasticsearch.helper.SQLHelper;
import fr.toutatice.ecm.elasticsearch.query.TTCNxQueryBuilder;
import fr.toutatice.ecm.elasticsearch.search.TTCSearchResponse;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jaxrs.DefaultJsonAdapter;
import org.nuxeo.ecm.automation.jaxrs.JsonAdapter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.QueryES", category="Fetch", label="Query via ElasticSerach", description="Perform a query on ElasticSerach instead of Repository")
public class QueryES {
    private static final Log log = LogFactory.getLog(QueryES.class);
    public static final String ID = "Document.QueryES";
    protected static final long DEFAULT_MAX_SIZE_RESULTS = Long.valueOf(Framework.getProperty((String)"ottc.es.query.default.limit", (String)"1000"));
    protected static final int OLD_DEFAULT_MAX_SIZE_RESULTS = 10000;
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Context
    protected ElasticSearchService elasticSearchService;
    @Context
    protected ElasticSearchAdmin elasticSearchAdmin;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="query", required=true)
    protected String query;
    @Param(name="queryLanguage", required=false, description="Language of the query parameter : NXQL or ES.", values={"NXQL"})
    protected String queryLanguage = QueryLanguage.NXQL.name();
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex;
    @Deprecated
    @Param(name="page", required=false)
    protected Integer page;
    @Param(name="X-NXDocumentProperties", required=false)
    protected String nxProperties;

    @OperationMethod
    public JsonAdapter run() throws OperationException {
        try {
            switch (QueryLanguage.valueOf(this.queryLanguage)) {
                case NXQL: {
                    return this.runNxqlSearch();
                }
                case ES: {
                    return this.runEsSearch();
                }
            }
            throw new OperationException("Illegal argument value for parameter 'queryLanguage' : " + this.queryLanguage);
        }
        catch (IllegalArgumentException e) {
            throw new OperationException("Illegal argument value for parameter 'queryLanguage' : " + this.queryLanguage, (Throwable)e);
        }
    }

    @OperationMethod
    public JsonAdapter runNxqlSearch() throws OperationException {
        long startTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("NXQL Query: [%s]", this.query));
        }
        TTCSearchResponse response = null;
        TTCNxQueryBuilder queryBuilder = this.getNxQueryBuilder();
        SearchResponse esResponse = this.nxqlSearch(queryBuilder);
        long hits = esResponse.getHits().getHits().length;
        if (hits > DEFAULT_MAX_SIZE_RESULTS) {
            if (log.isInfoEnabled()) {
                Principal principal = this.session.getPrincipal();
                String principalName = principal != null && principal.getName() != null ? principal.getName() : "null";
                log.info((Object)String.format("[%s][hits: %s][limit: %s][%s]", principalName, String.valueOf(hits), String.valueOf(queryBuilder.getLimit()), this.query));
            }
            SearchResponse emptyResponse = new SearchResponse(InternalSearchResponse.empty(), "", 0, 0, 0L, new ShardSearchFailure[0]);
            response = new TTCSearchResponse(emptyResponse, 0, 0, null);
        } else {
            String schemas = this.nxProperties;
            if (this.nxProperties == null) {
                schemas = this.getSchemasFromHeader(this.ctx);
            }
            response = new TTCSearchResponse(esResponse, this.pageSize, this.currentPageIndex, this.formatSchemas(schemas));
        }
        DefaultJsonAdapter responseAsJson = new DefaultJsonAdapter((Object)response);
        if (log.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - startTime;
            log.debug((Object)String.format("#runNxqlSearch: [TA_%s_TA] ms ", String.valueOf(duration)));
        }
        return responseAsJson;
    }

    protected SearchResponse nxqlSearch(TTCNxQueryBuilder builder) {
        builder.nxql(SQLHelper.getInstance().escape(this.query));
        Integer currentPageIndex = this.currentPageIndex;
        if (this.currentPageIndex == null) {
            currentPageIndex = this.page;
        }
        if (null != currentPageIndex && null != this.pageSize) {
            builder.offset((0 <= currentPageIndex ? currentPageIndex : 0) * this.pageSize);
            builder.limit(this.pageSize);
        } else {
            builder.limit(10000);
        }
        this.elasticSearchService.query((NxQueryBuilder)builder);
        return builder.getSearchResponse();
    }

    protected TTCNxQueryBuilder getNxQueryBuilder() {
        return new TTCNxQueryBuilder(this.session);
    }

    public String getSchemasFromHeader(OperationContext ctx) {
        String schemas;
        if ("transaction".equals(ctx.get((Object)"contextType"))) {
            schemas = (String)ctx.get((Object)"X-NXDocumentProperties");
        } else {
            HttpServletRequest httpRequest = (HttpServletRequest)ctx.get((Object)"request");
            schemas = httpRequest.getHeader("X-NXDocumentProperties");
        }
        return !StringUtils.equals((String)"*", (String)schemas) ? schemas : null;
    }

    protected List<String> formatSchemas(String nxProperties) {
        ArrayList<String> schemas = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)nxProperties)) {
            String[] schemasList;
            for (String schema : schemasList = nxProperties.split(",")) {
                Schema sch = this.schemaManager.getSchema(StringUtils.trim((String)schema));
                if (null != sch) {
                    String prefix = sch.getNamespace().prefix;
                    schemas.add(StringUtils.isNotBlank((String)prefix) ? prefix : sch.getName());
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Unknown schema '" + schema + "' (query='" + this.query + "')"));
            }
        }
        return schemas;
    }

    protected JsonAdapter runEsSearch() throws OperationException {
        SearchRequestBuilder request = this.elasticSearchAdmin.getClient().prepareSearch(new String[]{this.elasticSearchAdmin.getIndexNameForRepository(this.session.getRepositoryName())}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        request.setSource(this.getESRequestPayload());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/_search?pretty' -d '%s'", this.elasticSearchAdmin.getIndexNameForRepository(this.session.getRepositoryName()), request.toString()));
        }
        try {
            SearchResponse esResponse = (SearchResponse)request.get();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Result: " + esResponse.toString()));
            }
            return new DefaultJsonAdapter((Object)esResponse);
        }
        catch (ElasticsearchException e) {
            throw new OperationException("Error while executing the ElasticSearch request", (Throwable)e);
        }
    }

    public String getESRequestPayload() {
        JSONObject query;
        Principal principal = this.session.getPrincipal();
        if (principal == null || principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator()) {
            return this.query;
        }
        String[] principals = SecurityService.getPrincipalsToCheck((Principal)principal);
        JSONObject payloadJson = JSONObject.fromObject((Object)this.query);
        if (payloadJson.has("query")) {
            query = payloadJson.getJSONObject("query");
            payloadJson.remove("query");
        } else {
            query = JSONObject.fromObject((Object)"{\"match_all\":{}}");
        }
        JSONObject filterAcl = new JSONObject().element("terms", (Map)new JSONObject().element("ecm:acl", (Object)principals));
        JSONObject newQuery = new JSONObject().element("filtered", (Map)new JSONObject().element("query", (Map)query).element("filter", (Map)filterAcl));
        payloadJson.put((Object)"query", (Object)newQuery);
        String filteredPayload = payloadJson.toString();
        return filteredPayload;
    }

    public static enum QueryLanguage {
        NXQL,
        ES;

    }
}

