/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.es.status;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.count.CountResponse;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.elasticsearch.api.OttcElasticSearchAdmin;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.EsStateChecker;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.status.ReIndexingProcessStatus;
import org.opentoutatice.elasticsearch.core.reindexing.docs.index.IndexName;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.ReIndexingRunnerManager;

public class ReIndexingProcessStatusBuilder {
    private static final Log log = LogFactory.getLog(ReIndexingProcessStatusBuilder.class);
    public static final String TOTAL_DOCS_IN_BDD_QUERY = "select ecm:uuid from Document";
    public static final String NB_CREATED_DOCS_DURING_REINDEXING = "select ecm:uuid from Document where dc:created >= TIMESTAMP '%s'";
    public static final String NB_MODIFIED_DOCS_DURING_REINDEXING = "select ecm:uuid from Document where dc:modified >= TIMESTAMP '%s'";
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    private static ReIndexingProcessStatusBuilder instance;

    private ReIndexingProcessStatusBuilder() {
    }

    public static ReIndexingProcessStatusBuilder get() {
        if (instance == null) {
            instance = new ReIndexingProcessStatusBuilder();
        }
        return instance;
    }

    public ReIndexingProcessStatus build(String workId, String repository) {
        ReIndexingProcessStatus status = new ReIndexingProcessStatus();
        status.setStatus(ReIndexingRunnerManager.get().getRunnerStepFor(workId).getStepState().getStepStatus());
        status.setStartTime(new Date(ReIndexingRunnerManager.get().getStartTimeFor(workId)));
        status.setEndTime(ReIndexingRunnerManager.get().getEndTimeFor(workId));
        status.setDuration(this.getDuration(status));
        try {
            status.setEsState(EsStateChecker.get().getEsState());
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        status.setInitialNbDocsInBdd(ReIndexingRunnerManager.get().getInitialNbDocsInBddFor(workId));
        status.setNbDocsInBdd(this.getNbDocsInBdd(repository));
        status.setNewIndex(ReIndexingRunnerManager.get().getNewIndexFor(workId));
        status.setNbDocsInNewIndex(this.getNbDocsInNewIndex(status));
        status.setAverageReIndexingSpeed(this.getAverageSpeed(status));
        status.setNbCreatedDocsDuringReIndexing(this.getNbCreatedDocsDuringReIndexing(status, repository));
        status.setNbModifiedDocsDuringReIndexing(this.getNbModifiedDocsDuringReIndexing(status, repository));
        status.setNbDeletedDocsDuringReIndexing(this.getNbDeletedDocsDuringReIndexing(status));
        status.setNbContributedDocsNotIndexed(this.getNbContributedDocsNotIndexed(status));
        return status;
    }

    private float getDuration(ReIndexingProcessStatus status) {
        return (float)(status.getEndTime() - status.getStartTime().getTime()) / 1000.0f;
    }

    public long getNbDocsInBdd(String repository) {
        return this.queryNFetch(TOTAL_DOCS_IN_BDD_QUERY, repository);
    }

    protected long getNbDocsInNewIndex(ReIndexingProcessStatus status) {
        long nb = 0L;
        IndexName newIndex = status.getNewIndex();
        if (newIndex != null) {
            try {
                OttcElasticSearchAdmin esAdmin = (OttcElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
                CountResponse response = (CountResponse)esAdmin.getClient().prepareCount(new String[]{newIndex.toString()}).setQuery(NxqlQueryConverter.toESQueryBuilder((String)TOTAL_DOCS_IN_BDD_QUERY)).get();
                nb = response.getCount();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nb;
    }

    protected float getAverageSpeed(ReIndexingProcessStatus status) {
        return status.getDuration() > 0.0f ? (float)status.getNbDocsInNewIndex() / status.getDuration() : 0.0f;
    }

    protected long getNbCreatedDocsDuringReIndexing(ReIndexingProcessStatus status, String repository) {
        return this.queryNFetch(String.format(NB_CREATED_DOCS_DURING_REINDEXING, dateFormat.format(status.getStartTime())), repository);
    }

    protected long getNbModifiedDocsDuringReIndexing(ReIndexingProcessStatus status, String repository) {
        return this.queryNFetch(String.format(NB_MODIFIED_DOCS_DURING_REINDEXING, dateFormat.format(status.getStartTime())), repository);
    }

    protected long getNbDeletedDocsDuringReIndexing(ReIndexingProcessStatus status) {
        return status.getInitialNbDocsInBdd() + status.getNbCreatedDocsDuringReIndexing() - status.getNbDocsInBdd();
    }

    protected long getNbContributedDocsNotIndexed(ReIndexingProcessStatus status) {
        return status.getNbDocsInNewIndex() > 0L ? status.getNbDocsInBdd() - status.getNbDocsInNewIndex() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long queryNFetch(String query, String repository) {
        long nb = 0L;
        CoreSession session = null;
        IterableQueryResult rows = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Querying: [%s]", query));
            }
            session = CoreInstance.openCoreSessionSystem((String)repository);
            rows = session.queryAndFetch(query, "NXQL", new Object[0]);
            nb = rows.size();
        }
        finally {
            if (rows != null) {
                rows.close();
            }
            if (session != null) {
                session.close();
            }
        }
        return nb;
    }
}

