/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.query.filter;

import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;

public class ReIndexingTransientAggregate {
    public static final String DUPLICATE_AGGREGATE_NAME = "duplicate_aggregate";
    public static final String DUPLICATE_AGGREGATE_FIELD = "ecm:uuid";
    private static ReIndexingTransientAggregate instance;

    private ReIndexingTransientAggregate() {
    }

    public static synchronized ReIndexingTransientAggregate get() {
        if (instance == null) {
            instance = new ReIndexingTransientAggregate();
        }
        return instance;
    }

    public SearchRequestBuilder aggregateDuplicate(SearchRequestBuilder request, int nbBuckets) {
        TermsBuilder termsBuilder = (TermsBuilder)AggregationBuilders.terms((String)DUPLICATE_AGGREGATE_NAME).field(DUPLICATE_AGGREGATE_FIELD);
        termsBuilder.size(nbBuckets);
        request.addAggregation((AbstractAggregationBuilder)termsBuilder);
        return request;
    }
}

