/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.test;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.elasticsearch.client.Client;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.elasticsearch.core.reindexing.docs.transitory.TransitoryIndexUse;

public class EsNodeTestInitializer {
    public static void initializeEsNodeInTestMode(Client client, Log log) {
        if (BooleanUtils.isTrue((Boolean)Boolean.valueOf(Framework.getProperty((String)"ottc.reindexing.test.create.index.alias.on.startup")))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Creating index [%s] and its alias [%s].", "idx-tst", "nxutest-alias"));
            }
            client.admin().indices().prepareCreate("idx-tst").setSettings("{\n   \"number_of_shards\" : 1,\n   \"number_of_replicas\" : 0,\n   \"analysis\" : {\n      \"filter\" : {\n         \"truncate_filter\" : {\n            \"length\" : 256,\n            \"type\" : \"truncate\"\n         },\n         \"en_stem_filter\" : {\n            \"name\" : \"minimal_english\",\n            \"type\" : \"stemmer\"\n         },\n         \"en_stop_filter\" : {\n            \"stopwords\" : [\n               \"_english_\"\n            ],\n            \"type\" : \"stop\"\n         }\n      },\n      \"tokenizer\" : {\n         \"path_tokenizer\" : {\n            \"delimiter\" : \"/\",\n            \"type\" : \"path_hierarchy\"\n         }\n      },\n      \"analyzer\" : {\n         \"en_analyzer\" : {\n            \"alias\" : \"fulltext\",\n            \"filter\" : [\n               \"lowercase\",\n               \"en_stop_filter\",\n               \"en_stem_filter\",\n               \"asciifolding\"\n            ],\n            \"type\" : \"custom\",\n            \"tokenizer\" : \"standard\"\n         },\n         \"path_analyzer\" : {\n            \"type\" : \"custom\",\n            \"tokenizer\" : \"path_tokenizer\"\n         },\n         \"default\" : {\n            \"type\" : \"custom\",\n            \"tokenizer\" : \"keyword\",\n            \"filter\" : [\n               \"truncate_filter\"\n            ]\n         }\n      }\n   }\n}").get();
            client.admin().indices().preparePutMapping(new String[]{"idx-tst"}).setType("doc").setSource("{\n   \"_all\" : {\n      \"analyzer\" : \"fulltext\"\n   },\n   \"properties\" : {\n      \"dc:title\" : {\n         \"type\" : \"multi_field\",\n         \"fields\" : {\n           \"dc:title\" : {\n             \"type\" : \"string\"\n           },\n           \"fulltext\" : {\n             \"boost\": 2,\n             \"type\": \"string\",\n             \"analyzer\" : \"fulltext\"\n          }\n        }\n      },\n      \"dc:description\" : {\n         \"type\" : \"multi_field\",\n         \"fields\" : {\n           \"dc:description\" : {\n             \"type\" : \"string\"\n           },\n           \"fulltext\" : {\n             \"boost\": 1.5,\n             \"type\": \"string\",\n             \"analyzer\" : \"fulltext\"\n          }\n        }\n      },\n      \"ecm:binarytext\" : {\n         \"type\" : \"string\",\n         \"index\" : \"no\",\n         \"include_in_all\" : true\n      },\n      \"ecm:path\" : {\n         \"type\" : \"multi_field\",\n         \"fields\" : {\n            \"children\" : {\n               \"search_analyzer\" : \"keyword\",\n               \"index_analyzer\" : \"path_analyzer\",\n               \"type\" : \"string\"\n            },\n            \"ecm:path\" : {\n               \"index\" : \"not_analyzed\",\n               \"type\" : \"string\"\n            }\n         }\n      },\n      \"dc:created\": {\n         \"format\": \"dateOptionalTime\",\n        \"type\": \"date\"\n      },\n      \"dc:modified\": {\n         \"format\": \"dateOptionalTime\",\n        \"type\": \"date\"\n      },\n      \"ecm:pos*\" : {\n         \"type\" : \"integer\"\n      }\n   }\n}").get();
            client.admin().indices().prepareAliases().addAlias("idx-tst", "nxutest-alias").get();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Index [%s] and its alias [%s] created.", "idx-tst", "nxutest-alias"));
            }
            if (BooleanUtils.isTrue((Boolean)Boolean.valueOf(Framework.getProperty((String)"ottc.reindexing.test.create.bad.index.alias.on.startup")))) {
                client.admin().indices().prepareCreate("idx-tst-bad").get();
                client.admin().indices().prepareAliases().addAlias("idx-tst-bad", "nxutest-alias").get();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"BAD alias nxutest-alias created: points on 2 indices [idx-tst, idx-tst-bad]");
                }
            }
            if (BooleanUtils.isTrue((Boolean)Boolean.valueOf(Framework.getProperty((String)"ottc.reindexing.test.create.read.alias.on.startup")))) {
                client.admin().indices().prepareAliases().addAlias("idx-tst", TransitoryIndexUse.Read.getAlias()).get();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"BAD yet existing alias [r-alias] created on [idx-tst]");
                }
            }
            if (BooleanUtils.isTrue((Boolean)Boolean.valueOf(Framework.getProperty((String)"ottc.reindexing.test.create.bad.former.alias.on.startup")))) {
                client.admin().indices().prepareAliases().addAlias("idx-tst", "former-nxutest-alias").get();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"BAD former alias former-nxutest-alias created: points on index [idx-tst]");
                }
            }
        }
    }
}

