/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.List;
import com.lowagie.text.rtf.direct.RtfDirectContent;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.parser.RtfImportMappings;
import com.lowagie.text.rtf.parser.RtfImportMgr;
import com.lowagie.text.rtf.parser.RtfParserState;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordListener;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordMgr;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationMgr;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Stack;

public class RtfParser {
    private static final boolean debugParser = false;
    private String logFile = null;
    private boolean logging = false;
    private boolean logAppend = false;
    private Element elem = null;
    private Document document = null;
    private RtfDocument rtfDoc = null;
    private RtfCtrlWordMgr rtfKeywordMgr = null;
    private RtfImportMgr importMgr = null;
    private RtfDestinationMgr destinationMgr = null;
    private Stack stackState = null;
    private RtfParserState currentState = null;
    private PushbackInputStream pbReader = null;
    private int conversionType = 0;
    public static final int PARSER_IN_HEADER = 0;
    public static final int PARSER_IN_CHARSET = 1;
    public static final int PARSER_IN_DEFFONT = 2;
    public static final int PARSER_IN_FONT_TABLE = 3;
    public static final int PARSER_IN_FONT_TABLE_INFO = 4;
    public static final int PARSER_IN_FILE_TABLE = 5;
    public static final int PARSER_IN_COLOR_TABLE = 6;
    public static final int PARSER_IN_STYLESHEET = 7;
    public static final int PARSER_IN_LIST_TABLE = 8;
    public static final int PARSER_IN_LISTOVERRIDE_TABLE = 9;
    public static final int PARSER_IN_REV_TABLE = 10;
    public static final int PARSER_IN_RSID_TABLE = 11;
    public static final int PARSER_IN_GENERATOR = 12;
    public static final int PARSER_IN_PARAGRAPH_TABLE = 14;
    public static final int PARSER_IN_OLDCPROPS = 15;
    public static final int PARSER_IN_OLDPPROPS = 16;
    public static final int PARSER_IN_OLDTPROPS = 18;
    public static final int PARSER_IN_OLDSPROPS = 19;
    public static final int PARSER_IN_PROT_USER_TABLE = 20;
    public static final int PARSER_IN_LATENTSTYLES = 21;
    public static final int PARSER_IN_PARAGRAPH_GROUP_PROPERTIES = 22;
    public static final int PARSER_IN_DOCUMENT = 0x20000000;
    public static final int PARSER_IN_INFO_GROUP = 0x20000001;
    public static final int PARSER_IN_UPR = 0x20000002;
    public static final int PARSER_IN_SHPPICT = 0x20000010;
    public static final int PARSER_IN_PICT = 0x20000011;
    public static final int PARSER_IN_PICPROP = 0x20000012;
    public static final int PARSER_IN_BLIPUID = 536870931;
    public static final int PARSER_STARTSTOP = 0x40000001;
    public static final int PARSER_ERROR = Integer.MIN_VALUE;
    public static final int PARSER_ERROR_EOF = -2147483647;
    public static final int PARSER_IN_UNKNOWN = -1879048193;
    public static final int TYPE_UNIDENTIFIED = -1;
    public static final int TYPE_IMPORT_FULL = 0;
    public static final int TYPE_IMPORT_FRAGMENT = 1;
    public static final int TYPE_CONVERT = 2;
    public static final int TYPE_IMPORT_INTO_ELEMENT = 3;
    public static final int DESTINATION_NORMAL = 0;
    public static final int DESTINATION_SKIP = 1;
    public static final int TOKENISER_NORMAL = 0;
    public static final int TOKENISER_SKIP_BYTES = 1;
    public static final int TOKENISER_SKIP_GROUP = 2;
    public static final int TOKENISER_BINARY = 3;
    public static final int TOKENISER_HEX = 4;
    public static final int TOKENISER_IGNORE_RESULT = 5;
    public static final int TOKENISER_STATE_IN_ERROR = Integer.MIN_VALUE;
    public static final int TOKENISER_STATE_IN_UNKOWN = -16777216;
    private int groupLevel = 0;
    private int docGroupLevel = 0;
    private long binByteCount = 0L;
    private long binSkipByteCount = 0L;
    private int skipGroupLevel = 0;
    public static final int errOK = 0;
    public static final int errStackUnderflow = -1;
    public static final int errStackOverflow = -2;
    public static final int errUnmatchedBrace = -3;
    public static final int errInvalidHex = -4;
    public static final int errBadTable = -5;
    public static final int errAssertion = -6;
    public static final int errEndOfFile = -7;
    public static final int errCtrlWordNotFound = -8;
    private long byteCount = 0L;
    private long ctrlWordCount = 0L;
    private long openGroupCount = 0L;
    private long closeGroupCount = 0L;
    private long characterCount = 0L;
    private long ctrlWordHandledCount = 0L;
    private long ctrlWordNotHandledCount = 0L;
    private long ctrlWordSkippedCount = 0L;
    private long groupSkippedCount = 0L;
    private long startTime = 0L;
    private long endTime = 0L;
    private Date startDate = null;
    private Date endDate = null;
    private RtfCtrlWordData lastCtrlWordParam = null;
    private ArrayList listeners = new ArrayList();

    public RtfParser(Document document) {
        this.document = document;
    }

    public void importRtfDocument(InputStream inputStream, RtfDocument rtfDocument) throws IOException {
        if (inputStream == null || rtfDocument == null) {
            return;
        }
        this.init(0, rtfDocument, inputStream, this.document, null);
        this.setCurrentDestination("null");
        this.startDate = new Date();
        this.startTime = System.currentTimeMillis();
        this.groupLevel = 0;
        try {
            this.tokenise();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.endTime = System.currentTimeMillis();
        this.endDate = new Date();
    }

    public void importRtfDocumentIntoElement(Element element, InputStream inputStream, RtfDocument rtfDocument) throws IOException {
        if (inputStream == null || rtfDocument == null || element == null) {
            return;
        }
        this.init(3, rtfDocument, inputStream, this.document, element);
        this.setCurrentDestination("null");
        this.startDate = new Date();
        this.startTime = System.currentTimeMillis();
        this.groupLevel = 0;
        try {
            this.tokenise();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.endTime = System.currentTimeMillis();
        this.endDate = new Date();
    }

    public void convertRtfDocument(InputStream inputStream, Document document) throws IOException {
        if (inputStream == null || document == null) {
            return;
        }
        this.init(2, null, inputStream, document, null);
        this.setCurrentDestination("document");
        this.startDate = new Date();
        this.startTime = System.currentTimeMillis();
        this.groupLevel = 0;
        this.tokenise();
        this.endTime = System.currentTimeMillis();
        this.endDate = new Date();
    }

    public void importRtfFragment(InputStream inputStream, RtfDocument rtfDocument, RtfImportMappings rtfImportMappings) throws IOException {
        if (inputStream == null || rtfDocument == null || rtfImportMappings == null) {
            return;
        }
        this.init(1, rtfDocument, inputStream, null, null);
        this.handleImportMappings(rtfImportMappings);
        this.setCurrentDestination("document");
        this.groupLevel = 1;
        this.setParserState(0x20000000);
        this.startDate = new Date();
        this.startTime = System.currentTimeMillis();
        this.tokenise();
        this.endTime = System.currentTimeMillis();
        this.endDate = new Date();
    }

    public void addListener(EventListener eventListener) {
        this.listeners.add(eventListener);
    }

    public void removeListener(EventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    private void init(int n, RtfDocument rtfDocument, InputStream inputStream, Document document, Element element) {
        this.init_stats();
        this.pbReader = this.init_Reader(inputStream);
        this.conversionType = n;
        this.rtfDoc = rtfDocument;
        this.document = document;
        this.elem = element;
        this.currentState = new RtfParserState();
        this.stackState = new Stack();
        this.setParserState(0x40000001);
        this.importMgr = new RtfImportMgr(this.rtfDoc, this.document);
        this.destinationMgr = RtfDestinationMgr.getInstance(this);
        RtfDestinationMgr.setParser(this);
        this.rtfKeywordMgr = new RtfCtrlWordMgr(this, this.pbReader);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RtfCtrlWordListener)) continue;
            this.rtfKeywordMgr.addRtfCtrlWordListener((RtfCtrlWordListener)e);
        }
    }

    protected void init_stats() {
        this.byteCount = 0L;
        this.ctrlWordCount = 0L;
        this.openGroupCount = 0L;
        this.closeGroupCount = 0L;
        this.characterCount = 0L;
        this.ctrlWordHandledCount = 0L;
        this.ctrlWordNotHandledCount = 0L;
        this.ctrlWordSkippedCount = 0L;
        this.groupSkippedCount = 0L;
        this.startTime = 0L;
        this.endTime = 0L;
        this.startDate = null;
        this.endDate = null;
    }

    private PushbackInputStream init_Reader(InputStream inputStream) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream instanceof PushbackInputStream)) {
            inputStream = new PushbackInputStream(inputStream);
        }
        return (PushbackInputStream)inputStream;
    }

    private void handleImportMappings(RtfImportMappings rtfImportMappings) {
        String string;
        Iterator iterator = rtfImportMappings.getFontMappings().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.importMgr.importFont(string, (String)rtfImportMappings.getFontMappings().get(string));
        }
        iterator = rtfImportMappings.getColorMappings().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.importMgr.importColor(string, (Color)rtfImportMappings.getColorMappings().get(string));
        }
        iterator = rtfImportMappings.getListMappings().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.importMgr.importList(string, (String)rtfImportMappings.getListMappings().get(string));
        }
        iterator = rtfImportMappings.getStylesheetListMappings().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.importMgr.importStylesheetList(string, (List)rtfImportMappings.getStylesheetListMappings().get(string));
        }
    }

    public int handleOpenGroup() {
        int n = 0;
        ++this.openGroupCount;
        ++this.groupLevel;
        ++this.docGroupLevel;
        if (this.getTokeniserState() == 2) {
            ++this.groupSkippedCount;
        }
        RtfDestination rtfDestination = this.getCurrentDestination();
        boolean bl = false;
        if (rtfDestination != null) {
            bl = rtfDestination.handleOpeningSubGroup();
        }
        this.stackState.push(this.currentState);
        this.currentState = new RtfParserState(this.currentState);
        this.currentState.newGroup = true;
        rtfDestination = this.getCurrentDestination();
        if (rtfDestination != null) {
            bl = rtfDestination.handleOpenGroup();
        }
        return n;
    }

    public static void outputDebug(Object object, int n, String string) {
        System.out.println(string);
        if (object == null) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        char[] cArray = new char[n * 2];
        Arrays.fill(cArray, ' ');
        String string2 = new String(cArray);
        if (object instanceof RtfDocument) {
            ((RtfDocument)object).add(new RtfDirectContent("\n" + string2 + string));
        } else if (object instanceof Document) {
            try {
                ((Document)object).add((Element)new RtfDirectContent("\n" + string2 + string));
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
    }

    public int handleCloseGroup() {
        int n = 0;
        ++this.closeGroupCount;
        if (this.getTokeniserState() != 2) {
            RtfDestination rtfDestination = this.getCurrentDestination();
            boolean bl = false;
            if (rtfDestination != null) {
                bl = rtfDestination.handleCloseGroup();
            }
        }
        if (this.stackState.size() > 0) {
            this.currentState = (RtfParserState)this.stackState.pop();
        } else {
            n = -1;
        }
        --this.docGroupLevel;
        --this.groupLevel;
        if (this.getTokeniserState() == 2 && this.groupLevel < this.skipGroupLevel) {
            this.setTokeniserState(0);
        }
        return n;
    }

    public int handleCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        int n = 0;
        ++this.ctrlWordCount;
        if (this.getTokeniserState() == 2) {
            ++this.ctrlWordSkippedCount;
            return n;
        }
        n = this.rtfKeywordMgr.handleKeyword(rtfCtrlWordData, this.groupLevel);
        if (n == 0) {
            ++this.ctrlWordHandledCount;
        } else {
            ++this.ctrlWordNotHandledCount;
            n = 0;
        }
        return n;
    }

    public int handleCharacter(int n) {
        ++this.characterCount;
        if (this.getTokeniserState() == 2) {
            return 0;
        }
        boolean bl = false;
        RtfDestination rtfDestination = this.getCurrentDestination();
        if (rtfDestination != null) {
            bl = rtfDestination.handleCharacter(n);
        }
        return 0;
    }

    public RtfParserState getState() {
        return this.currentState;
    }

    public int getParserState() {
        return this.currentState.parserState;
    }

    public int setParserState(int n) {
        this.currentState.parserState = n;
        return this.currentState.parserState;
    }

    public int getConversionType() {
        return this.conversionType;
    }

    public RtfDocument getRtfDocument() {
        return this.rtfDoc;
    }

    public Document getDocument() {
        return this.document;
    }

    public RtfImportMgr getImportManager() {
        return this.importMgr;
    }

    public boolean setCurrentDestination(String string) {
        RtfDestination rtfDestination = RtfDestinationMgr.getDestination(string);
        if (rtfDestination != null) {
            this.currentState.destination = rtfDestination;
            return false;
        }
        this.setTokeniserStateSkipGroup();
        return false;
    }

    public RtfDestination getCurrentDestination() {
        return this.currentState.destination;
    }

    public RtfDestination getDestination(String string) {
        return RtfDestinationMgr.getDestination(string);
    }

    public boolean isNewGroup() {
        return this.currentState.newGroup;
    }

    public boolean setNewGroup(boolean bl) {
        this.currentState.newGroup = bl;
        return this.currentState.newGroup;
    }

    public void tokenise() throws IOException {
        Object object;
        int n = 0;
        int n2 = 0;
        this.setTokeniserState(0);
        block8: while ((n2 = this.pbReader.read()) != -1) {
            ++this.byteCount;
            if (this.getTokeniserState() == 3) {
                n = this.parseChar(n2);
                if (n == 0) continue;
                return;
            }
            switch (n2) {
                case 123: {
                    this.handleOpenGroup();
                    continue block8;
                }
                case 125: {
                    this.handleCloseGroup();
                    continue block8;
                }
                case 10: 
                case 13: {
                    continue block8;
                }
                case 92: {
                    if (this.parseCtrlWord(this.pbReader) == 0) continue block8;
                    return;
                }
            }
            if (this.groupLevel == 0) continue;
            if (this.getTokeniserState() == 4) {
                object = new StringBuffer();
                ((StringBuffer)object).append(n2);
                n2 = this.pbReader.read();
                if (n2 == -1) {
                    return;
                }
                ++this.byteCount;
                ((StringBuffer)object).append(n2);
                try {
                    n2 = Integer.parseInt(((StringBuffer)object).toString(), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                this.setTokeniserState(0);
            }
            if ((n = this.parseChar(n2)) == 0) continue;
            return;
        }
        object = this.getCurrentDestination();
        if (object != null) {
            ((RtfDestination)object).closeDestination();
        }
    }

    private int parseChar(int n) {
        if (this.getTokeniserState() == 3 && --this.binByteCount <= 0L) {
            this.setTokeniserStateNormal();
        }
        if (this.getTokeniserState() == 1 && --this.binSkipByteCount <= 0L) {
            this.setTokeniserStateNormal();
        }
        return this.handleCharacter(n);
    }

    private int parseCtrlWord(PushbackInputStream pushbackInputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        n = pushbackInputStream.read();
        if (n == -1) {
            return -7;
        }
        ++this.byteCount;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        RtfCtrlWordData rtfCtrlWordData = new RtfCtrlWordData();
        if (!Character.isLetterOrDigit((char)n)) {
            stringBuffer.append((char)n);
            rtfCtrlWordData.ctrlWord = stringBuffer.toString();
            n2 = this.handleCtrlWord(rtfCtrlWordData);
            this.lastCtrlWordParam = rtfCtrlWordData;
            return n2;
        }
        do {
            stringBuffer.append((char)n);
            n = pushbackInputStream.read();
            ++this.byteCount;
        } while (Character.isLetter((char)n));
        rtfCtrlWordData.ctrlWord = stringBuffer.toString();
        if (n == 45) {
            rtfCtrlWordData.isNeg = true;
            n = pushbackInputStream.read();
            if (n == -1) {
                return -7;
            }
            ++this.byteCount;
        }
        if (Character.isDigit((char)n)) {
            rtfCtrlWordData.hasParam = true;
            do {
                stringBuffer2.append((char)n);
                n = pushbackInputStream.read();
                ++this.byteCount;
            } while (Character.isDigit((char)n));
            rtfCtrlWordData.param = stringBuffer2.toString();
        }
        if (n != 32) {
            pushbackInputStream.unread(n);
        }
        n2 = this.handleCtrlWord(rtfCtrlWordData);
        this.lastCtrlWordParam = rtfCtrlWordData;
        return n2;
    }

    public int setTokeniserState(int n) {
        this.currentState.tokeniserState = n;
        return this.currentState.tokeniserState;
    }

    public int getTokeniserState() {
        return this.currentState.tokeniserState;
    }

    public int getLevel() {
        return this.groupLevel;
    }

    public void setTokeniserStateNormal() {
        this.setTokeniserState(0);
    }

    public void setTokeniserStateSkipGroup() {
        this.setTokeniserState(2);
        this.skipGroupLevel = this.groupLevel;
    }

    public void setTokeniserSkipBytes(long l) {
        this.setTokeniserState(1);
        this.binSkipByteCount = l;
    }

    public void setTokeniserStateBinary(int n) {
        this.setTokeniserState(3);
        this.binByteCount = n;
    }

    public void setTokeniserStateBinary(long l) {
        this.setTokeniserState(3);
        this.binByteCount = l;
    }

    public boolean isConvert() {
        return this.getConversionType() == 2;
    }

    public boolean isImport() {
        return this.isImportFull() || this.isImportFragment();
    }

    public boolean isImportFull() {
        return this.getConversionType() == 0;
    }

    public boolean isImportFragment() {
        return this.getConversionType() == 1;
    }

    public boolean getExtendedDestination() {
        return this.currentState.isExtendedDestination;
    }

    public boolean setExtendedDestination(boolean bl) {
        this.currentState.isExtendedDestination = bl;
        return this.currentState.isExtendedDestination;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public void setLogFile(String string, boolean bl) {
        this.logFile = string;
        this.setLogAppend(bl);
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public boolean isLogAppend() {
        return this.logAppend;
    }

    public void setLogAppend(boolean bl) {
        this.logAppend = bl;
    }
}

