/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.addon.quota.check;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.PathRef;
import org.opentoutatice.addon.quota.check.exception.QuotaExceededException;
import org.opentoutatice.addon.quota.check.util.BlobsSizeComputer;
import org.opentoutatice.addon.quota.check.util.QuotaResolver;

public class QuotaChecker {
    private static final Log log = LogFactory.getLog(QuotaChecker.class);
    private static QuotaChecker instance;
    protected QuotaResolver qResolver = QuotaResolver.get();
    protected BlobsSizeComputer bsComputer = BlobsSizeComputer.get();
    private static final String DEFAULT_ERROR_EXCEEDED_MESSAGE = "Quota exceeded";
    private static final String ERROR_EXCEEDED_LOCALIZED_MESSAGE = "label.error.quota.exceeded";

    private QuotaChecker() {
    }

    public static synchronized QuotaChecker get() {
        if (instance == null) {
            instance = new QuotaChecker();
        }
        return instance;
    }

    public void checkExceeding(CoreSession session, DocumentModel docToCreate, long fileSize) throws QuotaExceededException {
        long quotaValue = this.getQuota(session, docToCreate);
        if (quotaValue != -1L) {
            Long treeSize;
            Path parentPath = docToCreate.getPath().removeLastSegments(1);
            DocumentModel firstDoc = session.getDocument((DocumentRef)new PathRef(parentPath.toString()));
            DocumentModelList parentDocuments = ToutaticeDocumentHelper.getParentList((CoreSession)session, (DocumentModel)firstDoc, (Filter)new SpaceDocumentFilter(), (boolean)true);
            DocumentModel rootSpace = null;
            if (parentDocuments.size() > 0) {
                rootSpace = (DocumentModel)parentDocuments.get(0);
            }
            if ((treeSize = this.getTreeSizeFor(session, new PathRef(rootSpace.getPathAsString()))) + fileSize > quotaValue) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("treeSize + blob.lenght = %d + %d = %d > quota = %d", treeSize, fileSize, treeSize + fileSize, quotaValue));
                }
                throw new QuotaExceededException(DEFAULT_ERROR_EXCEEDED_MESSAGE, ERROR_EXCEEDED_LOCALIZED_MESSAGE, null);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("treeSize + blob.lenght = %d + %d = %d < quota = %d", treeSize, fileSize, treeSize + fileSize, quotaValue));
            }
        }
    }

    protected long getQuota(CoreSession session, DocumentModel blobPointer) {
        return this.qResolver.getQuotaFor(session, blobPointer, false);
    }

    public Long getTreeSizeFor(CoreSession session, PathRef pathRef) {
        return this.bsComputer.getTreeSizeFrom(session, (DocumentRef)pathRef);
    }

    private class SpaceDocumentFilter
    implements Filter {
        private static final long serialVersionUID = 3207718135474475149L;

        private SpaceDocumentFilter() {
        }

        public boolean accept(DocumentModel document) {
            boolean status = false;
            try {
                status = (document.hasFacet("Space") || document.hasFacet("SuperSpace")) && !document.getType().equals("Domain");
            }
            catch (Exception e) {
                log.error((Object)("Failed to filter the quota space document, error: " + e.getMessage()));
                status = false;
            }
            return status;
        }
    }
}

