/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.addon.quota.check.util;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

public class QuotaResolver {
    private static final Log log = LogFactory.getLog(QuotaResolver.class);
    private static QuotaResolver instance;

    private QuotaResolver() {
    }

    public static synchronized QuotaResolver get() {
        if (instance == null) {
            instance = new QuotaResolver();
        }
        return instance;
    }

    public long getQuotaFor(CoreSession session, DocumentModel blobPointer, boolean isFetchable) {
        UnrestrictedQuotaResolver uQuota = new UnrestrictedQuotaResolver(session, blobPointer, isFetchable);
        uQuota.runUnrestricted();
        Long quotaValue = -1L;
        DocumentModel uQuotaDoc = uQuota.getQuotaHolder();
        if (uQuotaDoc != null) {
            quotaValue = (Long)uQuotaDoc.getPropertyValue("qt:maxSize");
        }
        if (quotaValue != -1L) {
            quotaValue = quotaValue * 0x100000L;
        }
        return quotaValue;
    }

    private static class UnrestrictedQuotaResolver
    extends UnrestrictedSessionRunner {
        DocumentModel quotaHolder;
        private DocumentModel doc;
        private boolean isFetched = false;

        protected UnrestrictedQuotaResolver(CoreSession session, DocumentModel doc, boolean isFetched) {
            super(session);
            this.doc = doc;
            this.isFetched = isFetched;
        }

        public void run() throws ClientException {
            DocumentModel firstDoc = null;
            if (this.isFetched) {
                firstDoc = this.doc;
            } else {
                Path parentPath = this.doc.getPath().removeLastSegments(1);
                firstDoc = this.session.getDocument((DocumentRef)new PathRef(parentPath.toString()));
            }
            Filter quotaFilter = new Filter(){
                private static final long serialVersionUID = 1L;

                public boolean accept(DocumentModel doc) {
                    return doc.hasFacet("Quota");
                }
            };
            long beg_ = System.currentTimeMillis();
            DocumentModelList quotaHolders = ToutaticeDocumentHelper.getParentList((CoreSession)this.session, (DocumentModel)firstDoc, (Filter)quotaFilter, (boolean)true, (boolean)false, (boolean)true);
            for (DocumentModel q : quotaHolders) {
                if (q.getPropertyValue("qt:maxSize") == null) continue;
                this.quotaHolder = q;
                break;
            }
            if (log.isDebugEnabled()) {
                long end_ = System.currentTimeMillis();
                log.debug((Object)String.format("Quota serch executed in %d ms.", end_ - beg_));
            }
        }

        public DocumentModel getQuotaHolder() {
            return this.quotaHolder;
        }
    }
}

