/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.addon.quota.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.opentoutatice.addon.quota.check.QuotaChecker;

public class QuotaRecomputeListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext evtCtx = (DocumentEventContext)event.getContext();
            long size = 0L;
            DocumentModel document = evtCtx.getSourceDocument();
            if ("documentCreatedByCopy".equals(event.getName()) && document.hasFacet("Folderish")) {
                DocumentModel srcFolder = (DocumentModel)event.getContext().getArguments()[0];
                size = QuotaChecker.get().getTreeSizeFor(evtCtx.getCoreSession(), new PathRef(srcFolder.getPath().toString()));
            } else {
                BlobHolder bHolder = (BlobHolder)document.getAdapter(BlobHolder.class);
                if (bHolder != null && bHolder.getBlob() != null) {
                    size = bHolder.getBlob().getLength();
                }
            }
            if (size > 0L) {
                Path parentPath = document.getPath().removeLastSegments(1);
                DocumentModel firstDoc = evtCtx.getCoreSession().getDocument((DocumentRef)new PathRef(parentPath.toString()));
                DocumentModelList parentDocuments = ToutaticeDocumentHelper.getParentList((CoreSession)evtCtx.getCoreSession(), (DocumentModel)firstDoc, (Filter)new WorkspaceDocumentFilter(), (boolean)true);
                InnerSilentModifier runner = new InnerSilentModifier(evtCtx.getCoreSession(), (DocumentModel)parentDocuments.get(0));
                runner.silentRun(true);
            }
        }
    }

    private class InnerSilentModifier
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel workspace;

        public InnerSilentModifier(CoreSession session, DocumentModel workspace) {
            super(session);
            this.workspace = workspace;
        }

        public void run() throws ClientException {
            this.workspace.setPropertyValue("qtc:lastDateCheck", null);
            this.session.saveDocument(this.workspace);
        }
    }

    class WorkspaceDocumentFilter
    implements Filter {
        WorkspaceDocumentFilter() {
        }

        public boolean accept(DocumentModel docModel) {
            return docModel.getType().equals("Workspace");
        }
    }
}

