/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.addon.quota.service;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.service.quota.QuotaService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.PathRef;
import org.opentoutatice.addon.quota.check.util.BlobsSizeComputer;
import org.opentoutatice.addon.quota.check.util.QuotaResolver;

public class QuotaServiceImpl
implements QuotaService {
    public Long getFreeSpace(CoreSession session, DocumentModel doc) {
        long quota = QuotaResolver.get().getQuotaFor(session, doc, false);
        if (quota > 1L) {
            Filter workspaceFilter = new Filter(){
                private static final long serialVersionUID = 1L;

                public boolean accept(DocumentModel doc) {
                    return doc.getType().equals("Workspace");
                }
            };
            DocumentModelList workspaces = ToutaticeDocumentHelper.getParentList((CoreSession)session, (DocumentModel)doc, (Filter)workspaceFilter, (boolean)true, (boolean)true, (boolean)true);
            DocumentModel workspace = (DocumentModel)workspaces.get(0);
            Long spaceOccupied = BlobsSizeComputer.get().getTreeSizeFrom(session, (DocumentRef)new PathRef(workspace.getPathAsString()));
            long freeSpace = quota - spaceOccupied;
            return freeSpace > 0L ? freeSpace : 0L;
        }
        return null;
    }
}

