/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.addons.toutapad.ecm.automation;

import fr.toutatice.addons.toutapad.ecm.services.EtherpadClientService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etherpad_lite_client.EPLiteException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.ToutapadGetContent", category="Document", label="ToutapadGetContent", description="Fetch the Toutatice PAD content in html format of the document passed-in parameter. A string blob is returned containing the PAD html content.")
public class ToutapadGetContent {
    public static final String ID = "Document.ToutapadGetContent";
    private static final Log log = LogFactory.getLog(ToutapadGetContent.class);

    @OperationMethod
    public Blob run(DocumentModel document) {
        String content = null;
        try {
            EtherpadClientService service = (EtherpadClientService)Framework.getService(EtherpadClientService.class);
            String html = service.getPADContent(document, "html");
            Document doc = Jsoup.parse((String)html);
            Elements item = doc.select("body");
            content = item.html();
        }
        catch (EPLiteException e) {
            log.warn((Object)("Failed to get the PAD content, error: " + e.getMessage()));
            throw new ClientException((Throwable)e);
        }
        return new StringBlob(null != content ? content : "", "text/plain");
    }
}

