/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.addons.toutapad.ecm.automation;

import fr.toutatice.addons.toutapad.ecm.services.EtherpadClientService;
import net.sf.json.JSONObject;
import org.etherpad_lite_client.EPLiteException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.ToutapadJoinRequest", category="Document", label="ToutapadJoinRequest", description="Request to join a pad")
public class ToutapadJoinRequest {
    public static final String ID = "Document.ToutapadJoinRequest";
    @Param(name="path")
    protected String path;
    @Param(name="editionEnabled")
    protected Boolean editionEnabled;
    @Context
    protected CoreSession session;

    @OperationMethod
    public Blob run() {
        JSONObject jso = new JSONObject();
        try {
            EtherpadClientService service = (EtherpadClientService)Framework.getService(EtherpadClientService.class);
            PathRef pathRef = new PathRef(this.path);
            DocumentModel document = this.session.getDocument((DocumentRef)pathRef);
            String sessionId = service.grantAccess(this.session, document);
            jso.accumulate("sessionId", (Object)sessionId);
            if (this.session.hasPermission((DocumentRef)pathRef, "Write") && this.editionEnabled.booleanValue()) {
                String padPublicURL = service.getPADURL(document, true);
                jso.accumulate("url", (Object)padPublicURL);
            } else if (this.session.hasPermission((DocumentRef)pathRef, "Read")) {
                String padPublicURL = service.getPADReadOnlyURL(document);
                jso.accumulate("url", (Object)padPublicURL);
            }
        }
        catch (EPLiteException ex) {
            jso.accumulate("error", (Object)"pad.error");
        }
        return new StringBlob(jso.toString(), "application/json");
    }
}

