/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.attrs;

import com.phloc.commons.collections.attrs.IReadonlyAttributeContainer;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.typeconvert.TypeConverter;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractReadonlyAttributeContainer
implements IReadonlyAttributeContainer {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractReadonlyAttributeContainer.class);

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable String string) {
        return (DATATYPE)GenericReflection.uncheckedCast(this.getAttributeObject(string));
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable String string, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getCastedAttribute(string);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getTypedAttribute(@Nullable String string, @Nonnull Class<DATATYPE> clazz) {
        return TypeConverter.convertIfNecessary(this.getAttributeObject(string), clazz);
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getTypedAttribute(@Nullable String string, @Nonnull Class<DATATYPE> clazz, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getTypedAttribute(string, clazz);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable String string) {
        return this.getAttributeAsString(string, null);
    }

    @Nullable
    public static String getAsString(@Nullable String string, @Nullable Object object, @Nullable String string2) {
        if (object == null) {
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            Object[] objectArray = (String[])object;
            s_aLogger.warn("The parameter '" + string + "' is an array with " + objectArray.length + " items; using the first one if possible: " + Arrays.toString(objectArray));
            return objectArray.length > 0 ? objectArray[0] : string2;
        }
        return object.toString();
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable String string, @Nullable String string2) {
        Object object = this.getAttributeObject(string);
        return AbstractReadonlyAttributeContainer.getAsString(string, object, string2);
    }

    public static int getAsInt(@Nullable String string, @Nullable Object object, int n) {
        if (object == null) {
            return n;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        String string2 = AbstractReadonlyAttributeContainer.getAsString(string, object, null);
        return StringParser.parseInt(string2, n);
    }

    @Override
    public final int getAttributeAsInt(@Nullable String string) {
        return this.getAttributeAsInt(string, -1);
    }

    @Override
    public final int getAttributeAsInt(@Nullable String string, int n) {
        Object object = this.getAttributeObject(string);
        return AbstractReadonlyAttributeContainer.getAsInt(string, object, n);
    }

    public static long getAsLong(@Nullable String string, @Nullable Object object, long l) {
        if (object == null) {
            return l;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        String string2 = AbstractReadonlyAttributeContainer.getAsString(string, object, null);
        return StringParser.parseLong(string2, l);
    }

    @Override
    public final long getAttributeAsLong(@Nullable String string) {
        return this.getAttributeAsLong(string, -1L);
    }

    @Override
    public final long getAttributeAsLong(@Nullable String string, long l) {
        Object object = this.getAttributeObject(string);
        return AbstractReadonlyAttributeContainer.getAsLong(string, object, l);
    }

    public static double getAsDouble(@Nullable String string, @Nullable Object object, double d) {
        if (object == null) {
            return d;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        String string2 = AbstractReadonlyAttributeContainer.getAsString(string, object, null);
        return StringParser.parseDouble(string2, d);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable String string) {
        return this.getAttributeAsDouble(string, -1.0);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable String string, double d) {
        Object object = this.getAttributeObject(string);
        return AbstractReadonlyAttributeContainer.getAsDouble(string, object, d);
    }

    public static boolean getAsBoolean(@Nullable String string, @Nullable Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string2 = AbstractReadonlyAttributeContainer.getAsString(string, object, null);
        return StringParser.parseBool(string2, bl);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable String string) {
        return this.getAttributeAsBoolean(string, false);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable String string, boolean bl) {
        Object object = this.getAttributeObject(string);
        return AbstractReadonlyAttributeContainer.getAsBoolean(string, object, bl);
    }
}

