/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.i18n;

import com.phloc.commons.i18n.CodepointUtils;
import com.phloc.commons.i18n.ICodepointFilter;
import javax.annotation.Nonnull;

public enum ECodepointProfile {
    NONE(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return true;
        }
    }),
    ALPHA(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isAlpha(n);
        }
    }),
    ALPHANUM(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isAlphaDigit(n);
        }
    }),
    FRAGMENT(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isFragment(n);
        }
    }),
    IFRAGMENT(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_ifragment(n);
        }
    }),
    PATH(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isPath(n);
        }
    }),
    IPATH(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_ipath(n);
        }
    }),
    IUSERINFO(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_iuserinfo(n);
        }
    }),
    USERINFO(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isUserInfo(n);
        }
    }),
    QUERY(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isQuery(n);
        }
    }),
    IQUERY(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_iquery(n);
        }
    }),
    SCHEME(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isScheme(n);
        }
    }),
    PATHNODELIMS(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isPathNoDelims(n);
        }
    }),
    IPATHNODELIMS(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_ipathnodelims(n);
        }
    }),
    IPATHNODELIMS_SEG(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_ipathnodelims(n) && n != 64 && n != 58;
        }
    }),
    IREGNAME(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_iregname(n);
        }
    }),
    IHOST(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_ihost(n);
        }
    }),
    IPRIVATE(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_iprivate(n);
        }
    }),
    RESERVED(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isReserved(n);
        }
    }),
    IUNRESERVED(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_iunreserved(n);
        }
    }),
    UNRESERVED(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isUnreserved(n);
        }
    }),
    SCHEMESPECIFICPART(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_iunreserved(n) && !CodepointUtils.isReserved(n) && !CodepointUtils.is_iprivate(n) && !CodepointUtils.isPctEnc(n) && n != 35;
        }
    }),
    AUTHORITY(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.is_regname(n) && !CodepointUtils.isUserInfo(n) && !CodepointUtils.isGenDelim(n);
        }
    }),
    ASCIISANSCRLF(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.inRange(n, 1, 9) && !CodepointUtils.inRange(n, 14, 127);
        }
    }),
    PCT(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.isPctEnc(n);
        }
    }),
    STD3ASCIIRULES(new ICodepointFilter(){

        @Override
        public boolean accept(int n) {
            return !CodepointUtils.inRange(n, 0, 44) && !CodepointUtils.inRange(n, 46, 47) && !CodepointUtils.inRange(n, 58, 64) && !CodepointUtils.inRange(n, 91, 94) && !CodepointUtils.inRange(n, 96, 96) && !CodepointUtils.inRange(n, 123, 127);
        }
    });

    private final ICodepointFilter m_aFilter;

    private ECodepointProfile(ICodepointFilter iCodepointFilter) {
        this.m_aFilter = iCodepointFilter;
    }

    @Nonnull
    public ICodepointFilter getFilter() {
        return this.m_aFilter;
    }

    public boolean check(int n) {
        return this.m_aFilter.accept(n);
    }
}

