/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.CGlobal;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.string.StringHelper;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleFileIO {
    private static final SimpleFileIO s_aInstance = new SimpleFileIO();

    private SimpleFileIO() {
    }

    @Nullable
    public static byte[] readFileBytes(@Nullable File file) {
        return file == null ? null : StreamUtils.getAllBytes(FileUtils.getInputStream(file));
    }

    @Nullable
    @Deprecated
    public static String readFileAsString(@Nullable File file, @Nonnull String string) {
        return file == null ? null : StreamUtils.getAllBytesAsString(FileUtils.getInputStream(file), string);
    }

    @Nullable
    public static String readFileAsString(@Nullable File file, @Nonnull Charset charset) {
        return file == null ? null : StreamUtils.getAllBytesAsString(FileUtils.getInputStream(file), charset);
    }

    @Nullable
    @Deprecated
    public static List<String> readFileLines(@Nullable File file, @Nonnull String string) {
        return file == null ? null : StreamUtils.readStreamLines(FileUtils.getInputStream(file), string);
    }

    @Nullable
    public static List<String> readFileLines(@Nullable File file, @Nonnull Charset charset) {
        return file == null ? null : StreamUtils.readStreamLines(FileUtils.getInputStream(file), charset);
    }

    @Deprecated
    public static void readFileLines(@Nullable File file, @Nonnull String string, @Nonnull List<String> list) {
        if (file != null) {
            StreamUtils.readStreamLines(FileUtils.getInputStream(file), string, list);
        }
    }

    public static void readFileLines(@Nullable File file, @Nonnull Charset charset, @Nonnull List<String> list) {
        if (file != null) {
            StreamUtils.readStreamLines(FileUtils.getInputStream(file), charset, list);
        }
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull byte[] byArray) {
        OutputStream outputStream = FileUtils.getOutputStream(file);
        return outputStream == null ? ESuccess.FAILURE : StreamUtils.writeStream(outputStream, byArray);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        OutputStream outputStream = FileUtils.getOutputStream(file);
        return outputStream == null ? ESuccess.FAILURE : StreamUtils.writeStream(outputStream, byArray, n, n2);
    }

    @Nonnull
    @Deprecated
    public static ESuccess writeFile(@Nonnull File file, @Nonnull String string, @Nonnull String string2) {
        OutputStream outputStream = FileUtils.getOutputStream(file);
        return outputStream == null ? ESuccess.FAILURE : StreamUtils.writeStream(outputStream, string, string2);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull String string, @Nonnull Charset charset) {
        OutputStream outputStream = FileUtils.getOutputStream(file);
        return outputStream == null ? ESuccess.FAILURE : StreamUtils.writeStream(outputStream, string, charset);
    }

    @Nonnull
    @Deprecated
    public static ESuccess writeFile(@Nonnull File file, @Nonnull List<String> list, @Nonnull String string) {
        return SimpleFileIO.writeFile(file, StringHelper.getImploded(CGlobal.LINE_SEPARATOR, list), string);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull List<String> list, @Nonnull Charset charset) {
        return SimpleFileIO.writeFile(file, StringHelper.getImploded(CGlobal.LINE_SEPARATOR, list), charset);
    }
}

