/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IReadableResourceProvider;
import com.phloc.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReadableResourceProviderChain
implements IReadableResourceProvider {
    protected final List<IReadableResourceProvider> m_aReadingResourceProviders;

    public ReadableResourceProviderChain(IReadableResourceProvider ... iReadableResourceProviderArray) {
        ValueEnforcer.notEmptyNoNullValue(iReadableResourceProviderArray, "ResourceProviders");
        this.m_aReadingResourceProviders = ContainerHelper.newList(iReadableResourceProviderArray);
    }

    public ReadableResourceProviderChain(@Nonnull Iterable<? extends IReadableResourceProvider> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, "ResourceProviders");
        this.m_aReadingResourceProviders = ContainerHelper.newList(iterable);
    }

    @Override
    public final boolean supportsReading(@Nullable String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            if (!iReadableResourceProvider.supportsReading(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public IReadableResource getReadableResource(@Nonnull String string) {
        for (IReadableResourceProvider iReadableResourceProvider : this.m_aReadingResourceProviders) {
            if (!iReadableResourceProvider.supportsReading(string)) continue;
            return iReadableResourceProvider.getReadableResource(string);
        }
        throw new IllegalArgumentException("Cannot handle reading '" + string + "' by " + this.m_aReadingResourceProviders);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadableResourceProviderChain readableResourceProviderChain = (ReadableResourceProviderChain)object;
        return ((Object)this.m_aReadingResourceProviders).equals(readableResourceProviderChain.m_aReadingResourceProviders);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aReadingResourceProviders)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("resProviders", this.m_aReadingResourceProviders).toString();
    }
}

