/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.string.StringHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StackTraceHelper {
    private static final char STACKELEMENT_LINESEP = '\n';
    private static final List<String> STACKTRACE_OMIT_UNITTEST = new ArrayList<String>();
    private static final List<String> STACKTRACE_OMIT_APPSRV = new ArrayList<String>();
    private static final StackTraceHelper s_aInstance;

    private StackTraceHelper() {
    }

    private static boolean _stopStackTraceListing(@Nonnull String string) {
        for (String string2 : STACKTRACE_OMIT_UNITTEST) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        for (String string2 : STACKTRACE_OMIT_APPSRV) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean _matchesParentStackTrace(@Nonnull StackTraceElement stackTraceElement, @Nullable StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement2 : stackTraceElementArray) {
                if (!stackTraceElement2.equals(stackTraceElement)) continue;
                return true;
            }
        }
        return false;
    }

    private static void _appendSingleStackTraceToString(@Nonnull StringBuilder stringBuilder, @Nonnull StackTraceElement[] stackTraceElementArray, @Nullable StackTraceElement[] stackTraceElementArray2, boolean bl) {
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.toString();
            if (bl && StackTraceHelper._stopStackTraceListing(string) || StackTraceHelper._matchesParentStackTrace(stackTraceElement, stackTraceElementArray2)) {
                stringBuilder.append("  [").append(stackTraceElementArray.length - i).append(" elements omitted -- ").append(string).append(']').append('\n');
                break;
            }
            stringBuilder.append(i + 1).append(".: ").append(string).append('\n');
        }
    }

    public static void appendStackToString(@Nonnull StringBuilder stringBuilder, @Nonnull StackTraceElement[] stackTraceElementArray) {
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder, stackTraceElementArray, null, true);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull StackTraceElement[] stackTraceElementArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder, stackTraceElementArray, null, bl);
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getStackAsString(@Nonnull StackTraceElement[] stackTraceElementArray) {
        return StackTraceHelper.getStackAsString(stackTraceElementArray, true);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull Thread thread) {
        return StackTraceHelper.getStackAsString(thread.getStackTrace(), true);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull Thread thread, boolean bl) {
        return StackTraceHelper.getStackAsString(thread.getStackTrace(), bl);
    }

    @Nonnull
    public static String getCurrentThreadStackAsString() {
        return StackTraceHelper.getStackAsString(Thread.currentThread().getStackTrace(), true);
    }

    private static StringBuilder _getRecursiveStackAsStringBuilder(@Nonnull Throwable throwable, @Nullable Throwable throwable2, @Nullable StringBuilder stringBuilder, @Nonnegative int n, boolean bl) {
        StringBuilder stringBuilder2 = stringBuilder == null ? new StringBuilder() : stringBuilder;
        stringBuilder2.append(throwable.toString()).append('\n');
        StackTraceHelper._appendSingleStackTraceToString(stringBuilder2, throwable.getStackTrace(), throwable2 == null ? null : throwable2.getStackTrace(), bl);
        if (throwable.getCause() != null) {
            stringBuilder2.append("==> [").append(n).append("] caused by ");
            StackTraceHelper._getRecursiveStackAsStringBuilder(throwable.getCause(), throwable, stringBuilder2, n + 1, bl);
        }
        return stringBuilder2;
    }

    @Nonnull
    public static String getStackAsString(@Nullable Throwable throwable) {
        return StackTraceHelper.getStackAsString(throwable, true);
    }

    @Nonnull
    public static String getStackAsString(@Nullable Throwable throwable, boolean bl) {
        if (throwable == null) {
            return "";
        }
        StringBuilder stringBuilder = StackTraceHelper._getRecursiveStackAsStringBuilder(throwable, null, null, 1, bl);
        if (StringHelper.getLastChar(stringBuilder) == '\n') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static boolean containsUnitTestElement(@Nullable Throwable throwable) {
        return throwable != null && StackTraceHelper.containsUnitTestElement(throwable.getStackTrace());
    }

    public static boolean containsUnitTestElement(@Nullable StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                String string = stackTraceElement.toString();
                for (String string2 : STACKTRACE_OMIT_UNITTEST) {
                    if (!string.startsWith(string2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        STACKTRACE_OMIT_UNITTEST.add("org.testng");
        STACKTRACE_OMIT_UNITTEST.add("org.junit.");
        STACKTRACE_OMIT_UNITTEST.add("junit.framework.");
        STACKTRACE_OMIT_APPSRV.add("org.apache.catalina.core");
        STACKTRACE_OMIT_APPSRV.add("org.mortbay.jetty.");
        STACKTRACE_OMIT_APPSRV.add("org.eclipse.jetty.");
        s_aInstance = new StackTraceHelper();
    }
}

