/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.log;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IHasErrorLevel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class LogUtils {
    private static final LogUtils s_aInstance = new LogUtils();

    private LogUtils() {
    }

    public static boolean isEnabled(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel) {
        return LogUtils.isEnabled(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel) {
        return LogUtils.isEnabled(logger, iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Class<?> clazz, @Nonnull EErrorLevel eErrorLevel) {
        return LogUtils.isEnabled(LoggerFactory.getLogger(clazz), eErrorLevel);
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull EErrorLevel eErrorLevel) {
        if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.ERROR)) {
            return logger.isErrorEnabled();
        }
        if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.WARN)) {
            return logger.isWarnEnabled();
        }
        if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.INFO)) {
            return logger.isInfoEnabled();
        }
        return logger.isDebugEnabled();
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string) {
        LogUtils.log(clazz, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogUtils.log(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string) {
        LogUtils.log(logger, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogUtils.log(logger, iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull EErrorLevel eErrorLevel, @Nonnull String string) {
        LogUtils.log(clazz, eErrorLevel, string, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull EErrorLevel eErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogUtils.log(LoggerFactory.getLogger(clazz), eErrorLevel, string, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull EErrorLevel eErrorLevel, @Nonnull String string) {
        LogUtils.log(logger, eErrorLevel, string, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull EErrorLevel eErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        ValueEnforcer.notNull(logger, "Logger");
        ValueEnforcer.notNull(eErrorLevel, "ErrorLevel");
        ValueEnforcer.notNull(string, "Message");
        if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.ERROR)) {
            logger.error(string, throwable);
        } else if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.WARN)) {
            logger.warn(string, throwable);
        } else if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.INFO)) {
            logger.info(string, throwable);
        } else if (logger.isDebugEnabled()) {
            logger.debug(string, throwable);
        }
    }
}

