/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.system.EOperatingSystem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ENewLineMode {
    UNIX("\n"),
    MAC("\r"),
    WINDOWS("\r\n");

    public static final ENewLineMode DEFAULT;
    private final String m_sText;

    private ENewLineMode(String string2) {
        this.m_sText = string2;
    }

    @Nonnull
    @Nonempty
    public String getText() {
        return this.m_sText;
    }

    public boolean isUnix() {
        return this == UNIX;
    }

    public boolean isMac() {
        return this == MAC;
    }

    public boolean isWindows() {
        return this == WINDOWS;
    }

    @Nullable
    public static ENewLineMode getFromTextOrDefault(@Nullable String string, @Nullable ENewLineMode eNewLineMode) {
        if (string != null && string.length() > 0) {
            for (ENewLineMode eNewLineMode2 : ENewLineMode.values()) {
                if (!eNewLineMode2.m_sText.equals(string)) continue;
                return eNewLineMode2;
            }
        }
        return eNewLineMode;
    }

    @Nullable
    public static ENewLineMode getFromTextOrNull(@Nullable String string) {
        return ENewLineMode.getFromTextOrDefault(string, null);
    }

    static {
        DEFAULT = ENewLineMode.getFromTextOrDefault(CGlobal.LINE_SEPARATOR, EOperatingSystem.getCurrentOS().getNewLineMode());
    }
}

