/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.impl.DBReifierGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBReifier
implements Reifier {
    protected GraphRDB m_parent = null;
    protected Graph m_hiddenTriples = null;
    protected List<SpecializedGraphReifier> m_reifiers = null;
    protected List<SpecializedGraphReifier> m_hidden_reifiers = null;
    protected SpecializedGraphReifier m_reifier = null;
    protected ReificationStyle m_style;

    public DBReifier(GraphRDB parent, ReificationStyle style, List<SpecializedGraphReifier> allReifiers, List<SpecializedGraphReifier> hiddenReifiers) {
        this.m_parent = parent;
        this.m_reifiers = allReifiers;
        this.m_hidden_reifiers = hiddenReifiers;
        this.m_style = style;
        if (this.m_reifiers.size() != 1) {
            throw new BrokenException("Internal error - DBReifier requires exactly one SpecializedGraphReifier");
        }
        this.m_reifier = this.m_reifiers.get(0);
    }

    @Override
    public Graph getParentGraph() {
        return this.m_parent;
    }

    @Override
    public ReificationStyle getStyle() {
        return this.m_style;
    }

    private Graph getReificationTriples() {
        if (this.m_hiddenTriples == null) {
            this.m_hiddenTriples = new DBReifierGraph(this.m_parent, this.m_hidden_reifiers);
        }
        return this.m_hiddenTriples;
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m) {
        return this.getReificationTriples().find(m);
    }

    @Override
    public ExtendedIterator<Triple> findExposed(TripleMatch m) {
        return this.getReificationTriples().find(m);
    }

    @Override
    public ExtendedIterator<Triple> findEither(TripleMatch m, boolean showHidden) {
        return showHidden == this.m_style.conceals() ? this.getReificationTriples().find(m) : Triple.None;
    }

    @Override
    public int size() {
        return this.m_style.conceals() ? 0 : this.getReificationTriples().size();
    }

    protected static SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    @Override
    public Node reifyAs(Node n, Triple t) {
        this.m_reifier.add(n, t, DBReifier.newComplete());
        return n;
    }

    @Override
    public boolean hasTriple(Node n) {
        return this.m_reifier.findReifiedTriple(n, DBReifier.newComplete()) != null;
    }

    @Override
    public boolean hasTriple(Triple t) {
        return this.m_reifier.findReifiedNodes(t, DBReifier.newComplete()).hasNext();
    }

    @Override
    public ExtendedIterator<Node> allNodes() {
        return this.m_reifier.findReifiedNodes(null, DBReifier.newComplete());
    }

    @Override
    public ExtendedIterator<Node> allNodes(Triple t) {
        return this.m_reifier.findReifiedNodes(t, DBReifier.newComplete());
    }

    @Override
    public void remove(Node n, Triple t) {
        this.m_reifier.delete(n, t, DBReifier.newComplete());
    }

    @Override
    public void remove(Triple t) {
        this.m_reifier.delete(null, t, DBReifier.newComplete());
    }

    @Override
    public boolean handledAdd(Triple t) {
        SpecializedGraph.CompletionFlag complete = DBReifier.newComplete();
        this.m_reifier.add(t, complete);
        return complete.isDone();
    }

    @Override
    public boolean handledRemove(Triple t) {
        SpecializedGraph.CompletionFlag complete = DBReifier.newComplete();
        this.m_reifier.delete(t, complete);
        return complete.isDone();
    }

    @Override
    public Triple getTriple(Node n) {
        return this.m_reifier.findReifiedTriple(n, DBReifier.newComplete());
    }

    @Override
    public void close() {
    }
}

