/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.drive.services.helper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.runtime.api.Framework;

public class DriveHelper {
    private static final String HOST_JOKER = "__HOST__";
    public static final String NXDRIVE_PROTOCOL = "nxdrive";
    public static final String PROTOCOL_COMMAND_EDIT = "edit";
    public static final String NX_DRIVE_VOLATILE_TOKEN_CAHE = "ottc-volatile-drive-token-cache";
    public static final String NX_DRIVE_TOKEN_CACHE_KEY = "Nx-Drive-T-";
    public static final String AUTH_TOKEN_DIRECTORY_NAME = "authTokens";
    public static final String AUTH_TOKEN_DIRECTORY_SCHEMA = "authtoken";
    public static final String USERNAME_FIELD = "userName";
    public static final String TOKEN_FIELD = "token";
    public static final String APPLICATION_NAME_FIELD = "applicationName";
    public static final String DEVICE_ID_FIELD = "deviceId";
    private static final Log log = LogFactory.getLog(DriveHelper.class);

    private DriveHelper() {
    }

    public static FileSystemItem getFileSystemItem(DocumentModel doc) throws ClientException {
        FileSystemItem fileSystemItem = ((FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class)).getFileSystemItem(doc, null, false, false, false);
        if (fileSystemItem == null && log.isDebugEnabled()) {
            log.debug((Object)String.format("Document %s (%s) is not adaptable as a FileSystemItem.", doc.getPathAsString(), doc.getId()));
        }
        return fileSystemItem;
    }

    public static String getDriveEditURL(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        FileSystemItem currentFileSystemItem = DriveHelper.getFileSystemItem(currentDocument);
        if (currentFileSystemItem == null) {
            throw new ClientException(String.format("Document %s (%s) is not adaptable as a FileSystemItem thus not Drive editable, \"driveEdit\" action should not be displayed.", currentDocument.getId(), currentDocument.getPathAsString()));
        }
        BlobHolder bh = (BlobHolder)currentDocument.getAdapter(BlobHolder.class);
        if (bh == null) {
            throw new ClientException(String.format("Document %s (%s) is not a BlobHolder, cannot get Drive Edit URL.", currentDocument.getPathAsString(), currentDocument.getId()));
        }
        Blob blob = bh.getBlob();
        if (blob == null) {
            throw new ClientException(String.format("Document %s (%s) has no blob, cannot get Drive Edit URL.", currentDocument.getPathAsString(), currentDocument.getId()));
        }
        String fileName = blob.getFilename();
        StringBuffer sb = new StringBuffer();
        sb.append(NXDRIVE_PROTOCOL).append("://");
        sb.append(PROTOCOL_COMMAND_EDIT).append("/");
        sb.append(HOST_JOKER);
        sb.append("/repo/");
        sb.append(coreSession.getRepositoryName());
        sb.append("/nxdocid/");
        sb.append(currentDocument.getId());
        sb.append("/filename/");
        String escapedFilename = fileName.replaceAll("(/|\\\\|\\*|<|>|\\?|\"|:|\\|)", "-");
        sb.append(URIUtils.quoteURIPathComponent((String)escapedFilename, (boolean)true));
        return sb.toString();
    }
}

