/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl.adapters;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.TypeAdaptException;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.util.Properties;

public class JsonNodeToProperties
implements TypeAdapter {
    @Override
    public Object getAdaptedValue(OperationContext ctx, Object objectToAdapt) throws TypeAdaptException {
        JsonNode json = (JsonNode)objectToAdapt;
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator it = json.getFields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isArray()) {
                int size = value.size();
                if (size == 0) {
                    map.put(key, null);
                    continue;
                }
                if (size == 1) {
                    map.put(key, value.get(0).getValueAsText());
                    continue;
                }
                StringBuilder buf = new StringBuilder(size * 32);
                buf.append(value.get(0).getValueAsText());
                for (int i = 1; i < size; ++i) {
                    buf.append(',').append(value.get(i).getValueAsText());
                }
                map.put(key, buf.toString());
                continue;
            }
            if (value.isTextual()) {
                map.put(key, value.getTextValue());
                continue;
            }
            map.put(key, value.toString());
        }
        return new Properties((Map<String, String>)map);
    }
}

