/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.operations.document.DocumentPermissionHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Operation(id="Document.AddPermission", category="Document", label="Add Permission", description="Add Permission on the input document(s). Returns the document(s).")
public class AddPermission {
    public static final String ID = "Document.AddPermission";
    @Context
    protected CoreSession session;
    @Param(name="user")
    protected String user;
    @Param(name="permission")
    String permission;
    @Param(name="acl", required=false, values={"local"})
    String aclName = "local";
    @Param(name="blockInheritance", required=false)
    boolean blockInheritance = false;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws ClientException {
        this.addPermission(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) throws ClientException {
        DocumentModel doc = this.session.getDocument(docRef);
        this.addPermission(doc);
        return doc;
    }

    protected void addPermission(DocumentModel doc) throws ClientException {
        Object acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        boolean permissionChanged = DocumentPermissionHelper.addPermission(acp, this.aclName, this.user, this.permission, this.blockInheritance, this.session.getPrincipal().getName());
        if (permissionChanged) {
            doc.setACP(acp, true);
        }
    }
}

