/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.VersioningOption;

@Operation(id="Document.CheckIn", category="Document", label="Check In", description="Checks in the input document. Returns back the document.")
public class CheckInDocument {
    public static final String ID = "Document.CheckIn";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="version", required=true, values={"minor", "major"}, order=0)
    protected String version;
    @Param(name="comment", required=false, order=1)
    protected String comment;
    @Param(name="versionVarName", required=false, order=2)
    protected String versionVarName;

    protected VersioningOption getVersioningOption() {
        return "major".equalsIgnoreCase(this.version) ? VersioningOption.MAJOR : VersioningOption.MINOR;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) throws Exception {
        if (this.session.isCheckedOut(doc)) {
            DocumentRef ver = this.session.checkIn(doc, this.getVersioningOption(), this.comment);
            if (this.versionVarName != null) {
                this.ctx.put(this.versionVarName, (Object)ver);
            }
        } else if (this.versionVarName != null) {
            this.ctx.put(this.versionVarName, (Object)this.session.getLastDocumentVersion(doc));
        }
        return this.session.getDocument(doc);
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (doc.isCheckedOut()) {
            DocumentRef ver = this.session.checkIn(doc.getRef(), this.getVersioningOption(), this.comment);
            doc.refresh(1, null);
            if (this.versionVarName != null) {
                this.ctx.put(this.versionVarName, (Object)ver);
            }
        } else if (this.versionVarName != null) {
            this.ctx.put(this.versionVarName, (Object)this.session.getLastDocumentVersion(doc.getRef()));
        }
        return doc;
    }
}

