/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.tube.client;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import javax.xml.namespace.QName;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.tube.AbstractJreWssTube;

public class JreWssMUTube
extends AbstractJreWssTube {
    private final SOAPVersion soapVersion;

    public JreWssMUTube(WSBinding binding, Tube next) {
        super(next);
        this.soapVersion = binding.getSOAPVersion();
    }

    protected JreWssMUTube(JreWssMUTube that, TubeCloner cloner) {
        super(that, cloner);
        this.soapVersion = that.soapVersion;
    }

    public JreWssMUTube copy(TubeCloner cloner) {
        return new JreWssMUTube(this, cloner);
    }

    public NextAction processResponse(Packet response) {
        if (response.getMessage() == null || !response.getMessage().hasHeaders()) {
            return super.processResponse(response);
        }
        HeaderList headers = response.getMessage().getHeaders();
        for (int i = 0; i < headers.size(); ++i) {
            Header header;
            if (headers.isUnderstood(i) || (header = headers.get(i)).isIgnorable(this.soapVersion, this.soapVersion.implicitRoleSet)) continue;
            QName qName = new QName(header.getNamespaceURI(), header.getLocalPart());
            if (WSSE.equals(qName)) {
                this.checkSecurityHeader(header);
                continue;
            }
            throw new CmisConnectionException("MustUnderstand header is not understood: " + qName);
        }
        return super.processResponse(response);
    }

    private void checkSecurityHeader(Header header) {
    }
}

