/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;

public class DocumentRoutingWorkflowInstancesCleanup
implements EventListener {
    public static final String CLEANUP_WORKFLOW_INSTANCES_PROPERTY = "nuxeo.routing.disable.cleanup.workflow.instances";
    public static final String CLEANUP_WORKFLOW_INSTANCES_BATCH_SIZE_PROPERTY = "nuxeo.routing.cleanup.workflow.instances.batch.size";
    public static final String CLEANUP_WORKFLOW_REPO_NAME_PROPERTY = "repositoryName";
    public static final String CLEANUP_WORKFLOW_EVENT_NAME = "workflowInstancesCleanup";

    public void handleEvent(Event event) {
        if (!CLEANUP_WORKFLOW_EVENT_NAME.equals(event.getName()) || Framework.isBooleanPropertyTrue((String)CLEANUP_WORKFLOW_INSTANCES_PROPERTY)) {
            return;
        }
        int batchSize = Integer.parseInt(Framework.getProperty((String)CLEANUP_WORKFLOW_INSTANCES_BATCH_SIZE_PROPERTY, (String)"100"));
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        if (event.getContext().hasProperty(CLEANUP_WORKFLOW_REPO_NAME_PROPERTY)) {
            this.doCleanAndReschedule(batchSize, routing, event.getContext().getProperty(CLEANUP_WORKFLOW_REPO_NAME_PROPERTY).toString());
        } else {
            for (String repositoryName : repositoryManager.getRepositoryNames()) {
                this.doCleanAndReschedule(batchSize, routing, repositoryName);
            }
        }
    }

    private void doCleanAndReschedule(int batchSize, DocumentRoutingService routing, String repositoryName) {
        int cleanedUpWf = routing.doCleanupDoneAndCanceledRouteInstances(repositoryName, batchSize);
        if (cleanedUpWf == batchSize) {
            EventContextImpl eCtx = new EventContextImpl(new Object[0]);
            eCtx.setProperty(CLEANUP_WORKFLOW_REPO_NAME_PROPERTY, (Serializable)((Object)repositoryName));
            Event event = eCtx.newEvent(CLEANUP_WORKFLOW_EVENT_NAME);
            EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
            eventProducer.fireEvent(event);
        }
    }
}

