/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared;

import java.util.Dictionary;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceConfiguration {
    public static final String IP_PORT_KEY = "ipPort";
    public static final int MINUTE = 60000;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    protected static final String APACHE_SERVICE_CONFIGURATION = "apacheServiceConfiguration";
    protected static final String SERVICE_PID = "service.pid";
    protected static final String SERVICE_FACTORYPID = "service.factoryPid";
    private int bufferSize;
    private int ipPort;
    private String ipAddress;
    private String catalogBaseDn;
    private String searchBaseDn = "ou=users,dc=example,dc=com";
    private String initialContextFactory = "org.apache.directory.server.core.jndi.CoreContextFactory";
    private String securityAuthentication = "simple";
    private String securityPrincipal = "uid=admin,ou=system";
    private String securityCredentials = "secret";
    private String serviceName;
    private String servicePid;
    private boolean isEnabled = false;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public String getServicePid() {
        return this.servicePid;
    }

    public void setServicePid(String servicePid) {
        this.servicePid = servicePid;
    }

    public boolean isDifferent(Dictionary<String, Object> config) {
        int port = this.getIpPort();
        return port != Integer.parseInt((String)config.get(IP_PORT_KEY));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getIpPort() {
        return this.ipPort;
    }

    public String getCatalogBaseDn() {
        return this.catalogBaseDn;
    }

    public String getSearchBaseDn() {
        return this.searchBaseDn;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public void setCatalogBaseDn(String catalogBaseDn) {
        this.catalogBaseDn = catalogBaseDn;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setIpPort(int ipPort) {
        this.validatePortNumber(ipPort);
        this.ipPort = ipPort;
    }

    public void setSearchBaseDn(String searchBaseDn) {
        this.searchBaseDn = searchBaseDn;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this.securityAuthentication = securityAuthentication;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.securityPrincipal = securityPrincipal;
    }

    protected void validatePortNumber(int port) {
        if (port < 0 || port > 65535) {
            throw new ServiceConfigurationException("Invalid port number: " + port);
        }
    }
}

