/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.authn.Authenticator;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.configuration.AuthenticatorConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.LdapJndiProperties;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    public Map<String, Collection<Authenticator>> authenticators = new HashMap<String, Collection<Authenticator>>();
    private DirectoryServiceConfiguration factoryCfg;

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        this.factoryCfg = factoryCfg;
        for (AuthenticatorConfiguration config : factoryCfg.getStartupConfiguration().getAuthenticatorConfigurations()) {
            try {
                this.register(config);
            }
            catch (Exception e) {
                this.destroy();
                throw (NamingException)new NamingException("Failed to register authenticator.").initCause(e);
            }
        }
    }

    @Override
    public void destroy() {
        HashSet<Collection<Authenticator>> clonedAuthenticatorCollections = new HashSet<Collection<Authenticator>>();
        clonedAuthenticatorCollections.addAll(this.authenticators.values());
        for (Collection collection : clonedAuthenticatorCollections) {
            HashSet clonedAuthenticators = new HashSet();
            clonedAuthenticators.addAll(collection);
            for (Authenticator authenticator : clonedAuthenticators) {
                this.unregister(authenticator);
            }
        }
        this.authenticators.clear();
    }

    private Authenticator instantiateAuthenticator(AuthenticatorConfiguration cfg) throws NamingException {
        Class<?> authenticatorClass;
        if (cfg == null) {
            throw new IllegalStateException("Cannot get instance of authenticator without a proper configuration.");
        }
        try {
            authenticatorClass = Class.forName(cfg.getAuthenticatorClassName());
        }
        catch (ClassNotFoundException e) {
            String msg = "Could not load authenticator implementation class '" + cfg.getAuthenticatorClassName() + "' for authenticator with name " + cfg.getName();
            log.error(msg);
            throw new LdapConfigurationException(msg, (Throwable)e);
        }
        Authenticator authenticator = null;
        try {
            authenticator = (Authenticator)authenticatorClass.newInstance();
        }
        catch (InstantiationException e) {
            String msg = "No default constructor in authenticator implementation class '" + cfg.getAuthenticatorClassName() + "' for authenticator with name " + cfg.getName();
            log.error(msg);
            throw new LdapConfigurationException(msg, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String msg = "Default constructor for authenticator implementation class '" + cfg.getAuthenticatorClassName() + "' for authenticator with name " + cfg.getName() + " is not publicly accessible.";
            log.error(msg);
            throw new LdapConfigurationException(msg, (Throwable)e);
        }
        return authenticator;
    }

    private void register(AuthenticatorConfiguration cfg) throws NamingException {
        Authenticator authenticator = this.instantiateAuthenticator(cfg);
        authenticator.init(this.factoryCfg, cfg);
        Collection<Authenticator> authenticatorList = this.getAuthenticators(authenticator.getAuthenticatorType());
        if (authenticatorList == null) {
            authenticatorList = new ArrayList<Authenticator>();
            this.authenticators.put(authenticator.getAuthenticatorType(), authenticatorList);
        }
        authenticatorList.add(authenticator);
    }

    private void unregister(Authenticator authenticator) {
        Collection<Authenticator> authenticatorList = this.getAuthenticators(authenticator.getAuthenticatorType());
        if (authenticatorList == null) {
            return;
        }
        authenticatorList.remove(authenticator);
        try {
            authenticator.destroy();
        }
        catch (Throwable t) {
            log.warn("Failed to destroy an authenticator.", t);
        }
    }

    private Collection<Authenticator> getAuthenticators(String type) {
        Collection<Authenticator> result = this.authenticators.get(type);
        if (result != null && result.size() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Adding the entry " + AttributeUtils.toString((Attributes)opContext.getEntry()) + " for DN = '" + opContext.getDn().getUpName() + "'");
        }
        this.checkAuthenticated(MessageTypeEnum.ADD_REQUEST);
        next.add(opContext);
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Deleting name = '" + opContext.getDn().getUpName() + "'");
        }
        this.checkAuthenticated(MessageTypeEnum.DEL_REQUEST);
        next.delete(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public LdapDN getMatchedName(NextInterceptor next, GetMatchedNameOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Matching name = '" + opContext.getDn().getUpName() + "'");
        }
        this.checkAuthenticated();
        return next.getMatchedName(opContext);
    }

    @Override
    public Attributes getRootDSE(NextInterceptor next, GetRootDSEOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Getting root DSE");
        }
        this.checkAuthenticated();
        return next.getRootDSE(opContext);
    }

    @Override
    public LdapDN getSuffix(NextInterceptor next, GetSuffixOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Getting suffix for name = '" + opContext.getDn().getUpName() + "'");
        }
        this.checkAuthenticated();
        return next.getSuffix(opContext);
    }

    @Override
    public boolean hasEntry(NextInterceptor next, EntryOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Testing if entry name = '" + opContext.getDn().getUpName() + "' exists");
        }
        this.checkAuthenticated();
        return next.hasEntry(opContext);
    }

    @Override
    public NamingEnumeration<SearchResult> list(NextInterceptor next, ListOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Listing base = '" + opContext.getDn().getUpName() + "'");
        }
        this.checkAuthenticated();
        return next.list(opContext);
    }

    @Override
    public Iterator<String> listSuffixes(NextInterceptor next, ListSuffixOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Listing suffixes");
        }
        this.checkAuthenticated();
        return next.listSuffixes(opContext);
    }

    @Override
    public Attributes lookup(NextInterceptor next, LookupOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            List<String> attrIds = opContext.getAttrsId();
            if (attrIds != null && attrIds.size() != 0) {
                String attrs = StringTools.listToString(attrIds);
                log.debug("Lookup name = '" + opContext.getDn().getUpName() + "', attributes = " + attrs);
            } else {
                log.debug("Lookup name = '" + opContext.getDn().getUpName() + "', no attributes ");
            }
        }
        this.checkAuthenticated();
        return next.lookup(opContext);
    }

    private void invalidateAuthenticatorCaches(LdapDN principalDn) {
        for (String authMech : this.authenticators.keySet()) {
            Collection<Authenticator> authenticators = this.getAuthenticators(authMech);
            for (Authenticator authenticator : authenticators) {
                authenticator.invalidateCache(principalDn);
            }
        }
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug(opContext.toString());
        }
        this.checkAuthenticated(MessageTypeEnum.MODIFY_REQUEST);
        next.modify(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Modifying name = '" + opContext.getDn().getUpName() + "', new RDN = '" + opContext.getNewRdn() + "', " + "oldRDN = '" + opContext.getDelOldDn() + "'");
        }
        this.checkAuthenticated(MessageTypeEnum.MOD_DN_REQUEST);
        next.rename(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Moving name = '" + opContext.getDn().getUpName() + "' to name = '" + opContext.getParent() + "', new RDN = '" + opContext.getNewRdn() + "', oldRDN = '" + opContext.getDelOldDn() + "'");
        }
        this.checkAuthenticated(MessageTypeEnum.MOD_DN_REQUEST);
        next.moveAndRename(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Moving name = '" + opContext.getDn().getUpName() + " to name = '" + opContext.getParent().getUpName() + "'");
        }
        this.checkAuthenticated(MessageTypeEnum.MOD_DN_REQUEST);
        next.move(opContext);
        this.invalidateAuthenticatorCaches(opContext.getDn());
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor next, SearchOperationContext opContext) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Search for base = '" + opContext.getDn().getUpName() + "'");
        }
        this.checkAuthenticated(MessageTypeEnum.SEARCH_REQUEST);
        return next.search(opContext);
    }

    private void checkAuthenticated(MessageTypeEnum operation) throws NamingException {
        try {
            this.checkAuthenticated();
        }
        catch (IllegalStateException ise) {
            log.error("Attempted operation {} by unauthenticated caller.", (Object)operation.name());
            throw new IllegalStateException("Attempted operation by unauthenticated caller.");
        }
    }

    private void checkAuthenticated() throws NamingException {
        ServerContext ctx = (ServerContext)InvocationStack.getInstance().peek().getCaller();
        if (ctx.getPrincipal() != null) {
            if (ctx.getEnvironment().containsKey("java.naming.security.credentials")) {
                ctx.removeFromEnvironment("java.naming.security.credentials");
            }
            return;
        }
        throw new IllegalStateException("Attempted operation by unauthenticated caller.");
    }

    @Override
    public void bind(NextInterceptor next, BindOperationContext opContext) throws NamingException {
        String mechanism;
        LdapDN normBindDn = opContext.getDn();
        String bindUpDn = normBindDn.getUpName();
        if (IS_DEBUG) {
            log.debug("Bind operation. bindDn: " + bindUpDn);
        }
        ServerContext ctx = (ServerContext)InvocationStack.getInstance().peek().getCaller();
        if (IS_DEBUG) {
            log.debug("bind: principal: " + ctx.getPrincipal());
        }
        if (ctx.getPrincipal() != null) {
            if (ctx.getEnvironment().containsKey("java.naming.security.credentials")) {
                ctx.removeFromEnvironment("java.naming.security.credentials");
            }
            return;
        }
        Collection<Authenticator> authenticators = null;
        Iterator<String> i$ = opContext.getMechanisms().iterator();
        while (i$.hasNext() && (authenticators = this.getAuthenticators(mechanism = i$.next())) == null) {
        }
        if (authenticators == null) {
            log.debug("No authenticators found, delegating bind to the nexus.");
            next.bind(opContext);
            log.debug("Nexus succeeded on bind operation.");
            ctx.setPrincipal(new TrustedPrincipalWrapper(new LdapPrincipal(normBindDn, LdapJndiProperties.getAuthenticationLevel(ctx.getEnvironment()))));
            ctx.removeFromEnvironment("java.naming.security.credentials");
            return;
        }
        for (Authenticator authenticator : authenticators) {
            try {
                LdapPrincipal authorizationId = authenticator.authenticate(normBindDn, ctx);
                ctx.setPrincipal(new TrustedPrincipalWrapper(authorizationId));
                ctx.removeFromEnvironment("java.naming.security.credentials");
                return;
            }
            catch (LdapAuthenticationException e) {
                if (!log.isInfoEnabled()) continue;
                log.info("Authenticator " + authenticator.getClass() + " failed to authenticate " + bindUpDn);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Unexpected exception from " + authenticator.getClass() + " for principal " + bindUpDn, (Throwable)e);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Cannot bind to the server ");
        }
        throw new LdapAuthenticationException();
    }

    public final class TrustedPrincipalWrapper {
        private final LdapPrincipal principal;

        private TrustedPrincipalWrapper(LdapPrincipal principal) {
            this.principal = principal;
        }

        public LdapPrincipal getPrincipal() {
            return this.principal;
        }
    }
}

