/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.enumeration.SearchResultEnumeration;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.BTreeSearchResult;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeSearchResultEnumeration
implements SearchResultEnumeration {
    private BTreePartition partition = null;
    private final String[] attrIds;
    private final NamingEnumeration<IndexRecord> underlying;
    private boolean attrIdsHasStar = false;
    private boolean attrIdsHasPlus = false;
    private AttributeTypeRegistry registry = null;

    public BTreeSearchResultEnumeration(String[] attrIds, NamingEnumeration<IndexRecord> underlying, BTreePartition db, AttributeTypeRegistry registry) {
        this.partition = db;
        this.attrIds = attrIds;
        this.underlying = underlying;
        this.attrIdsHasStar = this.containsStar(attrIds);
        this.attrIdsHasPlus = this.containsPlus(attrIds);
        this.registry = registry;
    }

    @Override
    public void close() throws NamingException {
        this.underlying.close();
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.underlying.hasMore();
    }

    @Override
    public SearchResult next() throws NamingException {
        NamingEnumeration<String> list;
        Attributes entry;
        IndexRecord rec = this.underlying.next();
        String name = this.partition.getEntryUpdn((Long)rec.getEntryId());
        if (null == rec.getAttributes()) {
            rec.setAttributes(this.partition.lookup((Long)rec.getEntryId()));
        }
        if (this.attrIds == null) {
            entry = (Attributes)rec.getAttributes().clone();
        } else if (this.attrIdsHasPlus && this.attrIdsHasStar) {
            entry = (Attributes)rec.getAttributes().clone();
        } else if (this.attrIdsHasPlus) {
            entry = new AttributesImpl();
            for (int ii = 0; ii < this.attrIds.length; ++ii) {
                if (this.attrIds[ii].equals("+") || null == rec.getAttributes().get(this.attrIds[ii])) continue;
                Attribute attr = (Attribute)rec.getAttributes().get(this.attrIds[ii]).clone();
                entry.put(attr);
            }
            list = rec.getAttributes().getIDs();
            while (list.hasMore()) {
                String attrId = list.next();
                AttributeType attrType = this.registry.lookup(attrId);
                if (attrType.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
                Attribute attr = (Attribute)rec.getAttributes().get(attrId).clone();
                entry.put(attr);
            }
        } else if (this.attrIdsHasStar) {
            entry = new AttributesImpl();
            for (int ii = 0; ii < this.attrIds.length; ++ii) {
                if (this.attrIds[ii].equals("*") || null == rec.getAttributes().get(this.attrIds[ii])) continue;
                Attribute attr = (Attribute)rec.getAttributes().get(this.attrIds[ii]).clone();
                entry.put(attr);
            }
            list = rec.getAttributes().getIDs();
            while (list.hasMore()) {
                String attrId = list.next();
                AttributeType attrType = this.registry.lookup(attrId);
                if (attrType.getUsage() != UsageEnum.USER_APPLICATIONS) continue;
                Attribute attr = (Attribute)rec.getAttributes().get(attrId).clone();
                entry.put(attr);
            }
        } else {
            entry = new AttributesImpl();
            Attributes attrs = rec.getAttributes();
            for (int ii = 0; ii < this.attrIds.length && !"1.1".equals(this.attrIds[ii]); ++ii) {
                Attribute attr = AttributeUtils.getAttribute((Attributes)attrs, (AttributeType)this.registry.lookup(this.attrIds[ii]));
                if (null == attr) {
                    Iterator descendants = this.registry.descendants(this.attrIds[ii]);
                    while (descendants.hasNext()) {
                        AttributeType atype = (AttributeType)descendants.next();
                        attr = AttributeUtils.getAttribute((Attributes)attrs, (AttributeType)atype);
                        if (attr == null) continue;
                        entry.put((Attribute)attr.clone());
                    }
                    continue;
                }
                entry.put((Attribute)attr.clone());
            }
        }
        BTreeSearchResult result = new BTreeSearchResult((Long)rec.getEntryId(), name, null, entry);
        result.setRelative(false);
        return result;
    }

    private boolean containsStar(String[] ids) {
        if (ids == null) {
            return false;
        }
        for (int ii = ids.length - 1; ii >= 0; --ii) {
            if (!ids[ii].trim().equals("*")) continue;
            return true;
        }
        return false;
    }

    private boolean containsPlus(String[] ids) {
        if (ids == null) {
            return false;
        }
        for (int ii = ids.length - 1; ii >= 0; --ii) {
            if (!ids[ii].trim().equals("+")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMoreElements() {
        return this.underlying.hasMoreElements();
    }

    @Override
    public SearchResult nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            NoSuchElementException nsee = new NoSuchElementException("Encountered NamingException on underlying enumeration.");
            nsee.initCause(e);
            throw nsee;
        }
    }
}

