/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.ExpressionEnumerator;
import org.apache.directory.server.core.partition.impl.btree.ExpressionEvaluator;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.Optimizer;
import org.apache.directory.server.core.partition.impl.btree.SearchEngine;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.message.DerefAliasesEnum;
import org.apache.directory.shared.ldap.name.LdapDN;

public class DefaultSearchEngine
implements SearchEngine {
    private final Optimizer optimizer;
    private BTreePartition db;
    private ExpressionEvaluator evaluator;
    private ExpressionEnumerator enumerator;

    public DefaultSearchEngine(BTreePartition db, ExpressionEvaluator evaluator, ExpressionEnumerator enumerator, Optimizer optimizer) {
        this.db = db;
        this.evaluator = evaluator;
        this.enumerator = enumerator;
        this.optimizer = optimizer;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public NamingEnumeration search(Name base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        Object effectiveBase = null;
        Long baseId = this.db.getEntryId(base.toString());
        String aliasedBase = (String)this.db.getAliasIndex().reverseLookup((Object)baseId);
        DerefAliasesEnum mode = DerefAliasesEnum.getEnum((Map)env);
        effectiveBase = null == aliasedBase || !mode.isDerefFindingBase() ? base : (null != aliasedBase ? new LdapDN(aliasedBase) : base);
        BranchNode root = new BranchNode(AssertionEnum.AND);
        ScopeNode node = new ScopeNode(env, effectiveBase.toString(), searchCtls.getSearchScope());
        root.getChildren().add(node);
        root.getChildren().add(filter);
        this.optimizer.annotate((ExprNode)root);
        return this.enumerator.enumerate((ExprNode)root);
    }

    public boolean evaluate(ExprNode ilter, Long id) throws NamingException {
        IndexRecord rec = new IndexRecord();
        rec.setEntryId((Object)id);
        return this.evaluator.evaluate(ilter, rec);
    }
}

