/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.SearchEngine;
import org.apache.directory.server.core.partition.impl.btree.gui.ASTNode;
import org.apache.directory.server.core.partition.impl.btree.gui.AboutDialog;
import org.apache.directory.server.core.partition.impl.btree.gui.AddEntryDialog;
import org.apache.directory.server.core.partition.impl.btree.gui.AnnotatedFilterTreeDialog;
import org.apache.directory.server.core.partition.impl.btree.gui.AttributesTableModel;
import org.apache.directory.server.core.partition.impl.btree.gui.EntryNode;
import org.apache.directory.server.core.partition.impl.btree.gui.FilterDialog;
import org.apache.directory.server.core.partition.impl.btree.gui.IndexDialog;
import org.apache.directory.server.core.partition.impl.btree.gui.SearchResultDialog;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.message.DerefAliasesEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionFrame
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(PartitionFrame.class);
    private static final long serialVersionUID = 4049353102291513657L;
    private JLabel statusBar = new JLabel("Ready");
    private JPanel mainPnl = new JPanel();
    private JSplitPane splitPane = new JSplitPane();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel entryPnl = new JPanel();
    private JPanel idxPnl = new JPanel();
    private JScrollPane treePane = new JScrollPane();
    private JTree tree = new JTree();
    private JScrollPane entryPane = new JScrollPane();
    private JTable entryTbl = new JTable();
    private JScrollPane idxPane = new JScrollPane();
    private JTable idxTbl = new JTable();
    private JMenu searchMenu = new JMenu();
    private JMenuItem annotate = new JMenuItem();
    private JMenuItem run = new JMenuItem();
    private JMenuItem debug = new JMenuItem();
    private JMenu indices = new JMenu();
    private BTreePartition partition = null;
    private boolean doCleanUp = false;
    private HashMap nodes = new HashMap();
    private EntryNode root = null;
    private SearchEngine eng = null;

    public PartitionFrame(BTreePartition db, SearchEngine eng) throws NamingException {
        this.partition = db;
        this.eng = eng;
        this.initialize();
        this.buildIndicesMenu(this.partition);
        this.pack();
        this.load();
    }

    private void initialize() throws NamingException {
        this.mainPnl.setBorder(null);
        this.mainPnl.setLayout(new BorderLayout());
        this.mainPnl.add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)this.tabbedPane, "right");
        this.splitPane.add((Component)this.treePane, "left");
        this.tabbedPane.add((Component)this.entryPnl, "Entry Attributes");
        this.tabbedPane.add((Component)this.idxPnl, "Entry Indices");
        this.entryPnl.setLayout(new BorderLayout());
        this.entryPnl.add((Component)this.entryPane, "Center");
        this.idxPnl.setLayout(new BorderLayout());
        this.idxPnl.add((Component)this.idxPane, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel();
        content.setPreferredSize(new Dimension(798, 461));
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEtchedBorder());
        content.add((Component)this.mainPnl, "North");
        this.getContentPane().add((Component)content, "Center");
        this.setTitle("Partition: " + this.partition.getSuffix().toString());
        this.getContentPane().add((Component)this.statusBar, "South");
        JMenuBar menuBar = new JMenuBar();
        JMenu backendMenu = new JMenu("Backend");
        backendMenu.setText("Partition");
        backendMenu.setBackground(new Color(205, 205, 205));
        backendMenu.setMnemonic('B');
        JMenuItem add = new JMenuItem("Add");
        backendMenu.add(add);
        add.setMnemonic('A');
        add.setBackground(new Color(205, 205, 205));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PartitionFrame.this.doAddDialog();
            }
        });
        JMenuItem importItem = new JMenuItem("Import");
        backendMenu.add(importItem);
        importItem.setMnemonic('I');
        importItem.setBackground(new Color(205, 205, 205));
        importItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PartitionFrame.this.doImport();
            }
        });
        JMenuItem exit = new JMenuItem("Exit");
        backendMenu.add(exit);
        exit.setMnemonic('E');
        exit.setBackground(new Color(205, 205, 205));
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PartitionFrame.this.exitForm();
            }
        });
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem about = new JMenuItem("About");
        about.setMnemonic('A');
        about.setBackground(new Color(205, 205, 205));
        about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog aboutDialog = new AboutDialog((Frame)PartitionFrame.this, true);
                PartitionFrame.this.centerOnScreen(aboutDialog);
                aboutDialog.setVisible(true);
            }
        });
        helpMenu.setBackground(new Color(205, 205, 205));
        helpMenu.add(about);
        menuBar.setBackground(new Color(196, 197, 203));
        menuBar.add(backendMenu);
        menuBar.add(this.searchMenu);
        menuBar.add(this.indices);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
        this.setBounds(new Rectangle(0, 0, 802, 515));
        this.setSize(new Dimension(802, 515));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PartitionFrame.this.exitForm();
            }
        });
        this.treePane.getViewport().add(this.tree);
        this.tree.setBounds(new Rectangle(6, 184, 82, 80));
        this.tree.setShowsRootHandles(true);
        this.tree.setToolTipText("DB DIT");
        this.tree.setScrollsOnExpand(true);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path == null) {
                    return;
                }
                Object last = path.getLastPathComponent();
                try {
                    if (last instanceof EntryNode) {
                        PartitionFrame.this.displayEntry(((EntryNode)last).getEntryId(), ((EntryNode)last).getLdapEntry());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.entryPane.getViewport().add(this.entryTbl);
        this.entryTbl.setBounds(new Rectangle(321, 103, 32, 32));
        this.idxPane.getViewport().add(this.idxTbl);
        this.idxTbl.setBounds(new Rectangle(429, 134, 32, 32));
        this.treePane.setSize(new Dimension(285, 435));
        this.treePane.setPreferredSize(new Dimension(285, 403));
        this.searchMenu.setText("Search");
        this.searchMenu.setBackground(new Color(205, 205, 205));
        this.searchMenu.add(this.run);
        this.searchMenu.add(this.debug);
        this.searchMenu.add(this.annotate);
        ActionListener searchHandler = new ActionListener(){

            public void actionPerformed(ActionEvent an_event) {
                if (log.isDebugEnabled()) {
                    log.debug("action command = " + an_event.getActionCommand());
                }
                try {
                    PartitionFrame.this.doFilterDialog(an_event.getActionCommand());
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        };
        this.annotate.setText("Annotate");
        this.annotate.setActionCommand("Annotate");
        this.annotate.setBackground(new Color(205, 205, 205));
        this.annotate.addActionListener(searchHandler);
        this.run.setText("Run");
        this.run.setActionCommand("Run");
        this.run.setBackground(new Color(205, 205, 205));
        this.run.addActionListener(searchHandler);
        this.debug.setText("Debug");
        this.debug.setActionCommand("Debug");
        this.debug.setBackground(new Color(205, 205, 205));
        this.debug.addActionListener(searchHandler);
        this.indices.setText("Indices");
        this.indices.setBackground(new Color(205, 205, 205));
    }

    private void centerOnScreen(Window window) {
        Dimension frameSize = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        window.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void doAddDialog() {
        try {
            Object last;
            TreePath path = this.tree.getSelectionModel().getSelectionPath();
            String parentDn = this.partition.getSuffix().toString();
            if (null != path && (last = path.getLastPathComponent()) instanceof EntryNode) {
                parentDn = ((EntryNode)last).getEntryDn();
            }
            if (null == parentDn) {
                JOptionPane.showMessageDialog(this, "Must select a parent entry to add a child to!");
                return;
            }
            AddEntryDialog dialog = new AddEntryDialog((Frame)this, false);
            dialog.setParentDn(parentDn);
            this.centerOnScreen(dialog);
            dialog.setEnabled(true);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSelectedDn() throws NamingException {
        TreePath path = this.tree.getSelectionModel().getSelectionPath();
        if (null == path) {
            return this.partition.getSuffix().toString();
        }
        Object last = path.getLastPathComponent();
        String base = null;
        if (last instanceof EntryNode) {
            try {
                base = ((EntryNode)last).getEntryDn();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        } else {
            base = this.partition.getSuffix().toString();
        }
        return base;
    }

    public void doImport() {
        FileReader in = null;
        JFileChooser chooser = new JFileChooser();
        int choice = chooser.showOpenDialog(this);
        File selected = chooser.getSelectedFile();
        if (0 != choice) {
            return;
        }
        try {
            in = new FileReader(selected);
            LdifReader list = new LdifReader((Reader)in);
            while (list.hasNext()) {
                Entry entry = (Entry)list.next();
                String updn = entry.getDn();
                Attributes attrs = entry.getAttributes();
                LdapDN ndn = new LdapDN(StringTools.deepTrimToLower((String)updn));
                if (null != this.partition.getEntryId(ndn.toString())) continue;
                this.partition.add(new AddOperationContext(ndn, attrs));
                this.load();
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void exitForm() {
        this.setEnabled(false);
        this.setVisible(false);
        this.dispose();
        if (this.doCleanUp && this.partition != null) {
            try {
                this.partition.sync();
                this.partition.destroy();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
    }

    public void doRunDebugAnnotate(FilterDialog dialog, String mode) {
        block6: {
            try {
                if (mode == "Run") {
                    this.doRun(dialog.getFilter(), dialog.getScope(), dialog.getBase(), dialog.getLimit());
                    break block6;
                }
                if (mode == "Debug") {
                    this.doDebug(dialog.getFilter(), dialog.getScope(), dialog.getBase(), dialog.getLimit());
                    break block6;
                }
                if (mode == "Annotate") {
                    if (!this.doAnnotate(dialog.getFilter())) {
                        return;
                    }
                    break block6;
                }
                throw new RuntimeException("Unrecognized mode.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doFilterDialog(final String mode) throws NamingException {
        final FilterDialog dialog = new FilterDialog(mode, this, true);
        if (this.tree.getSelectionModel().getSelectionPath() != null) {
            dialog.setBase(this.getSelectedDn());
        } else {
            dialog.setBase(this.partition.getSuffix().toString());
        }
        dialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent an_event) {
                String cmd = an_event.getActionCommand();
                if (cmd.equals("Search")) {
                    PartitionFrame.this.doRunDebugAnnotate(dialog, mode);
                } else if (!cmd.equals("Cancel")) {
                    throw new RuntimeException("Unrecognized FilterDialog command: " + cmd);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.setSize(456, 256);
        this.centerOnScreen(dialog);
        dialog.setEnabled(true);
        dialog.setVisible(true);
    }

    public boolean doRun(String filter, String scope, String base, String limit) throws Exception {
        int count;
        if (log.isDebugEnabled()) {
            log.debug("Search attempt using filter '" + filter + "' " + "with scope '" + scope + "' and a return limit of '" + limit + "'");
        }
        FilterParserImpl parser = new FilterParserImpl();
        ExprNode root = null;
        try {
            root = parser.parse(filter);
        }
        catch (Exception e) {
            e.printStackTrace();
            JTextArea text = new JTextArea();
            String msg = e.getMessage();
            if (msg.length() > 1024) {
                msg = msg.substring(0, 1024) + "\n. . . truncated . . .";
            }
            text.setText(msg);
            text.setEnabled(false);
            JOptionPane.showMessageDialog(null, text, "Syntax Error", 0);
            return false;
        }
        SearchControls ctls = new SearchControls();
        if (scope == "Base Object") {
            ctls.setSearchScope(0);
        } else if (scope == "Single Level") {
            ctls.setSearchScope(1);
        } else if (scope == "Subtree Level") {
            ctls.setSearchScope(2);
        } else {
            throw new RuntimeException("Unexpected scope parameter: " + scope);
        }
        int limitMax = Integer.MAX_VALUE;
        if (!limit.equals("Unlimited")) {
            limitMax = Integer.parseInt(limit);
        }
        Hashtable<String, DerefAliasesEnum> env = new Hashtable<String, DerefAliasesEnum>();
        env.put("java.naming.ldap.derefAliases", DerefAliasesEnum.DEREF_ALWAYS);
        NamingEnumeration cursor = this.eng.search((Name)new LdapDN(base), env, root, ctls);
        Object[] cols = new String[]{"id", "dn"};
        DefaultTableModel tableModel = new DefaultTableModel(cols, 0);
        Object[] row = new Object[2];
        for (count = 0; cursor.hasMore() && count < limitMax; ++count) {
            IndexRecord rec = (IndexRecord)cursor.next();
            row[0] = rec.getEntryId();
            row[1] = this.partition.getEntryDn((Long)row[0]);
            tableModel.addRow(row);
        }
        SearchResultDialog results = new SearchResultDialog((Frame)this, false);
        StringBuffer buf = new StringBuffer();
        buf.append("base: ");
        buf.append(base);
        buf.append("\n");
        buf.append("scope: ");
        buf.append(scope);
        buf.append("\n");
        buf.append("limit: ");
        buf.append(limit);
        buf.append("\n");
        buf.append("total: ");
        buf.append(count);
        buf.append("\n");
        buf.append("filter:\n");
        buf.append(filter);
        buf.append("\n");
        results.setFilter(buf.toString());
        ASTNode astRoot = new ASTNode(null, root);
        DefaultTreeModel treeModel = new DefaultTreeModel(astRoot, true);
        results.setTreeModel(treeModel);
        results.setTableModel(tableModel);
        this.centerOnScreen(results);
        results.setVisible(true);
        return true;
    }

    public void doDebug(String filter, String scope, String base, String limit) {
        if (log.isDebugEnabled()) {
            log.debug("Search attempt using filter '" + filter + "' " + "with scope '" + scope + "' and a return limit of '" + limit + "'");
        }
    }

    public void selectTreeNode(Long id) {
        Stack<EntryNode> stack = new Stack<EntryNode>();
        Object[] comps = null;
        for (TreeNode parent = (EntryNode)this.nodes.get(id); parent != null && parent != parent.getParent(); parent = parent.getParent()) {
            stack.push((EntryNode)parent);
        }
        comps = stack.size() == 0 ? new Object[]{this.root} : new Object[stack.size()];
        for (int ii = 0; stack.size() > 0 && ii < comps.length; ++ii) {
            comps[ii] = stack.pop();
        }
        TreePath path = new TreePath(comps);
        this.tree.scrollPathToVisible(path);
        this.tree.getSelectionModel().setSelectionPath(path);
        this.tree.validate();
    }

    public boolean doAnnotate(String filter) throws Exception {
        FilterParserImpl parser = new FilterParserImpl();
        ExprNode root = null;
        try {
            root = parser.parse(filter);
        }
        catch (Exception e) {
            JTextArea text = new JTextArea();
            String msg = e.getMessage();
            if (msg.length() > 1024) {
                msg = msg.substring(0, 1024) + "\n. . . truncated . . .";
            }
            text.setText(msg);
            text.setEnabled(false);
            JOptionPane.showMessageDialog(null, text, "Syntax Error", 0);
            return false;
        }
        AnnotatedFilterTreeDialog treeDialog = new AnnotatedFilterTreeDialog((Frame)this, false);
        treeDialog.setFilter(filter);
        this.eng.getOptimizer().annotate(root);
        ASTNode astRoot = new ASTNode(null, root);
        DefaultTreeModel model = new DefaultTreeModel(astRoot, true);
        treeDialog.setModel(model);
        treeDialog.setVisible(true);
        return true;
    }

    public void showIndexDialog(String idxAttr) throws Exception {
        Index index = null;
        boolean isSystem = this.partition.hasSystemIndexOn(idxAttr);
        index = isSystem ? this.partition.getSystemIndex(idxAttr) : this.partition.getUserIndex(idxAttr);
        if (index != null) {
            IndexDialog dialog = new IndexDialog((Frame)this, false, index);
            this.centerOnScreen(dialog);
            dialog.setEnabled(true);
            dialog.setVisible(true);
        }
    }

    public void buildIndicesMenu(BTreePartition partition) {
        String idx;
        JMenuItem item = null;
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    PartitionFrame.this.showIndexDialog(event.getActionCommand());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Iterator list = partition.getSystemIndices();
        while (list.hasNext()) {
            idx = (String)list.next();
            item = new JMenuItem();
            item.setBackground(new Color(205, 205, 205));
            this.indices.add(item);
            item.setText(idx);
            item.setActionCommand(idx);
            item.addActionListener(listener);
        }
        this.indices.add(new JSeparator());
        list = partition.getUserIndices();
        while (list.hasNext()) {
            idx = (String)list.next();
            item = new JMenuItem();
            item.setBackground(new Color(205, 205, 205));
            this.indices.add(item);
            item.setText(idx);
            item.setActionCommand(idx);
            item.addActionListener(listener);
        }
    }

    void displayEntry(Long id, Attributes entry) throws Exception {
        String dn = this.partition.getEntryUpdn(id);
        AttributesTableModel model = new AttributesTableModel(entry, id, dn, false);
        this.entryTbl.setModel(model);
        model = new AttributesTableModel(this.partition.getIndices(id), id, dn, false);
        this.idxTbl.setModel(model);
        this.validate();
    }

    private void load() throws NamingException {
        this.nodes = new HashMap();
        Attributes suffix = this.partition.getSuffixEntry();
        Long id = this.partition.getEntryId(this.partition.getSuffix().toString());
        this.root = new EntryNode(id, null, this.partition, suffix, this.nodes);
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.tree.setModel(model);
        if (this.isVisible()) {
            this.tree.validate();
        }
    }
}

