/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.BTreePartitionConfiguration;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexNotFoundException;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmStore;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmStoreConfiguration;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;

public class JdbmPartition
extends BTreePartition {
    private JdbmStore store = new JdbmStore();

    protected void initRegistries1(Registries registries) {
        super.initRegistries1(registries);
        this.store.initRegistries(registries);
    }

    public final void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
        this.initOptimizerAndConfiguration0(cfg);
        this.initRegistries1(factoryCfg.getRegistries());
        JdbmStoreConfiguration storeConfig = new JdbmStoreConfiguration();
        storeConfig.setAttributeTypeRegistry(this.attributeTypeRegistry);
        storeConfig.setCacheSize(cfg.getCacheSize());
        storeConfig.setContextEntry(cfg.getContextEntry());
        storeConfig.setIndexedAttributes(cfg.getIndexedAttributes());
        storeConfig.setName(cfg.getId());
        storeConfig.setOidRegistry(this.oidRegistry);
        storeConfig.setSuffixDn(cfg.getSuffix());
        storeConfig.setWorkingDirectory(new File(factoryCfg.getStartupConfiguration().getWorkingDirectory().getPath() + File.separator + cfg.getId()));
        if (cfg instanceof BTreePartitionConfiguration) {
            storeConfig.setSyncOnWrite(((BTreePartitionConfiguration)cfg).isSynchOnWrite());
        }
        if (cfg instanceof BTreePartitionConfiguration) {
            storeConfig.setEnableOptimizer(((BTreePartitionConfiguration)cfg).isOptimizerEnabled());
        }
        this.store.init(storeConfig);
    }

    public final void destroy() {
        this.store.destroy();
    }

    public final boolean isInitialized() {
        return this.store.isInitialized();
    }

    public final void sync() throws NamingException {
        this.store.sync();
    }

    public final void addIndexOn(AttributeType spec, int cacheSize, int numDupLimit) throws NamingException {
        this.store.addIndexOn(spec, cacheSize, numDupLimit);
    }

    public final Index getExistanceIndex() {
        return this.store.getExistanceIndex();
    }

    public final void setExistanceIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        this.store.setExistanceIndexOn(attrType, cacheSize, numDupLimit);
    }

    public final Index getHierarchyIndex() {
        return this.store.getHierarchyIndex();
    }

    public final void setHierarchyIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        this.store.setHierarchyIndexOn(attrType, cacheSize, numDupLimit);
    }

    public final Index getAliasIndex() {
        return this.store.getAliasIndex();
    }

    public final void setAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        this.store.setAliasIndexOn(attrType, cacheSize, numDupLimit);
    }

    public final Index getOneAliasIndex() {
        return this.store.getOneAliasIndex();
    }

    public final void setOneAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        this.store.setOneAliasIndexOn(attrType, cacheSize, numDupLimit);
    }

    public final Index getSubAliasIndex() {
        return this.store.getSubAliasIndex();
    }

    public final void setSubAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        this.store.setSubAliasIndexOn(attrType, cacheSize, numDupLimit);
    }

    public final Index getUpdnIndex() {
        return this.store.getUpdnIndex();
    }

    public final void setUpdnIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        this.store.setUpdnIndexOn(attrType, cacheSize, numDupLimit);
    }

    public final Index getNdnIndex() {
        return this.store.getNdnIndex();
    }

    public final void setNdnIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        this.store.setNdnIndexOn(attrType, cacheSize, numDupLimit);
    }

    public final Iterator getUserIndices() {
        return this.store.getUserIndices();
    }

    public final Iterator getSystemIndices() {
        return this.store.getSystemIndices();
    }

    public final boolean hasUserIndexOn(String id) throws NamingException {
        return this.store.hasUserIndexOn(id);
    }

    public final boolean hasSystemIndexOn(String id) throws NamingException {
        return this.store.hasSystemIndexOn(id);
    }

    public final Index getUserIndex(String id) throws IndexNotFoundException {
        return this.store.getUserIndex(id);
    }

    public final Index getSystemIndex(String id) throws IndexNotFoundException {
        return this.store.getSystemIndex(id);
    }

    public final Long getEntryId(String dn) throws NamingException {
        return this.store.getEntryId(dn);
    }

    public final String getEntryDn(Long id) throws NamingException {
        return this.store.getEntryDn(id);
    }

    public final Long getParentId(String dn) throws NamingException {
        return this.store.getParentId(dn);
    }

    public final Long getParentId(Long childId) throws NamingException {
        return this.store.getParentId(childId);
    }

    public final String getEntryUpdn(Long id) throws NamingException {
        return this.store.getEntryUpdn(id);
    }

    public final String getEntryUpdn(String dn) throws NamingException {
        return this.getEntryUpdn(dn);
    }

    public final int count() throws NamingException {
        return this.store.count();
    }

    public final void add(AddOperationContext addContext) throws NamingException {
        this.store.add(addContext.getDn(), addContext.getEntry());
    }

    public final Attributes lookup(Long id) throws NamingException {
        return this.store.lookup(id);
    }

    public final void delete(Long id) throws NamingException {
        this.store.delete(id);
    }

    public final NamingEnumeration list(Long id) throws NamingException {
        return this.store.list(id);
    }

    public final int getChildCount(Long id) throws NamingException {
        return this.store.getChildCount(id);
    }

    public final LdapDN getSuffix() {
        return this.store.getSuffix();
    }

    public final LdapDN getUpSuffix() {
        return this.store.getUpSuffix();
    }

    public final Attributes getSuffixEntry() throws NamingException {
        return this.store.getSuffixEntry();
    }

    public final void setProperty(String propertyName, String propertyValue) throws NamingException {
        this.store.setProperty(propertyName, propertyValue);
    }

    public final String getProperty(String propertyName) throws NamingException {
        return this.store.getProperty(propertyName);
    }

    public final Attributes getIndices(Long id) throws NamingException {
        return this.store.getIndices(id);
    }

    public final void modify(ModifyOperationContext modifyContext) throws NamingException {
        this.store.modify(modifyContext.getDn(), modifyContext.getModItems());
    }

    public final void rename(RenameOperationContext renameContext) throws NamingException {
        this.store.rename(renameContext.getDn(), renameContext.getNewRdn(), renameContext.getDelOldDn());
    }

    public final void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws NamingException {
        this.store.move(moveAndRenameContext.getDn(), moveAndRenameContext.getParent(), moveAndRenameContext.getNewRdn(), moveAndRenameContext.getDelOldDn());
    }

    public final void move(MoveOperationContext moveContext) throws NamingException {
        this.store.move(moveContext.getDn(), moveContext.getParent());
    }

    public final void bind(LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
        throw new LdapAuthenticationNotSupportedException("Bind requests only tunnel down into partitions if there are no authenticators to handle the mechanism.\nCheck to see if you have correctly configured authenticators for the server.", ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
    }

    public final void bind(BindOperationContext bindContext) throws NamingException {
        throw new LdapAuthenticationNotSupportedException("Bind requests only tunnel down into partitions if there are no authenticators to handle the mechanism.\nCheck to see if you have correctly configured authenticators for the server.", ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
    }

    public final void unbind(UnbindOperationContext unbindContext) throws NamingException {
    }
}

