/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.apache.directory.server.core.schema.AbstractSchema;
import org.apache.directory.server.core.schema.AttributeClassLoader;
import org.apache.directory.server.core.schema.AttributeTypeImpl;
import org.apache.directory.server.core.schema.MatchingRuleImpl;
import org.apache.directory.server.core.schema.ObjectClassImpl;
import org.apache.directory.server.core.schema.SyntaxImpl;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Base64;

public class SchemaEntityFactory {
    private static final Class[] parameterTypes = new Class[]{Registries.class};
    private static final Class[] setOidParameterTypes = new Class[]{String.class};
    private static final String[] EMPTY = new String[0];
    private final Registries bootstrapRegistries;
    private final AttributeClassLoader classLoader;
    private final AttributeType oidAT;
    private final AttributeType byteCodeAT;

    public SchemaEntityFactory(Registries bootstrapRegistries) throws NamingException {
        this.bootstrapRegistries = bootstrapRegistries;
        this.classLoader = new AttributeClassLoader();
        this.oidAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-oid");
        this.byteCodeAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
    }

    public Schema getSchema(Attributes entry) throws NamingException {
        String[] dependencies = EMPTY;
        boolean isDisabled = false;
        if (entry == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (entry.get("cn") == null) {
            throw new NullPointerException("entry must have a valid cn attribute");
        }
        String name = (String)entry.get("cn").get();
        if (entry.get("creatorsName") == null) {
            throw new NullPointerException("entry must have a valid creatorsName attribute");
        }
        String owner = (String)entry.get("creatorsName").get();
        if (entry.get("m-disabled") != null) {
            String value = (String)entry.get("m-disabled").get();
            value = value.toUpperCase();
            isDisabled = value.equals("TRUE");
        }
        if (entry.get("m-dependencies") != null) {
            HashSet<String> depsSet = new HashSet<String>();
            Attribute depsAttr = entry.get("m-dependencies");
            for (int ii = 0; ii < depsAttr.size(); ++ii) {
                depsSet.add((String)depsAttr.get(ii));
            }
            dependencies = depsSet.toArray(EMPTY);
        }
        return new AbstractSchema(name, owner, dependencies, isDisabled){};
    }

    private SyntaxChecker getSyntaxChecker(String syntaxOid, String className, Attribute bytecode, Registries targetRegistries) throws NamingException {
        Class<?> clazz = null;
        SyntaxChecker syntaxChecker = null;
        try {
            if (bytecode == null) {
                clazz = Class.forName(className);
            } else {
                this.classLoader.setAttribute(bytecode);
                clazz = this.classLoader.loadClass(className);
            }
        }
        catch (ClassNotFoundException e) {
            LdapNamingException ne = new LdapNamingException("Normalizer class " + className + " was not found", ResultCodeEnum.OTHER);
            ne.setRootCause((Throwable)e);
            throw ne;
        }
        try {
            syntaxChecker = (SyntaxChecker)clazz.newInstance();
        }
        catch (InstantiationException e) {
            LdapNamingException ne = new LdapNamingException("Failed to instantiate SyntaxChecker class " + className + ".\nCheck that a default constructor exists for the class.", ResultCodeEnum.OTHER);
            ne.setRootCause((Throwable)e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            LdapNamingException ne = new LdapNamingException("Failed to instantiate SyntaxChecker class " + className + ".\nCheck that a **PUBLIC** accessible default constructor exists for the class.", ResultCodeEnum.OTHER);
            ne.setRootCause((Throwable)e);
            throw ne;
        }
        this.injectRegistries(syntaxChecker, targetRegistries);
        this.injectOid(syntaxOid, syntaxChecker);
        return syntaxChecker;
    }

    public SyntaxChecker getSyntaxChecker(Attributes entry, Registries targetRegistries) throws NamingException {
        if (entry == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (entry.get("m-fqcn") == null) {
            throw new NullPointerException("entry must have a valid m-fqcn attribute");
        }
        String className = (String)entry.get("m-fqcn").get();
        String syntaxOid = (String)AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.oidAT).get();
        return this.getSyntaxChecker(syntaxOid, className, AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.byteCodeAT), targetRegistries);
    }

    public SyntaxChecker getSyntaxChecker(SyntaxCheckerDescription syntaxCheckerDescription, Registries targetRegistries) throws NamingException {
        BasicAttribute attr = null;
        if (syntaxCheckerDescription.getBytecode() != null) {
            byte[] bytecode = Base64.decode((char[])syntaxCheckerDescription.getBytecode().toCharArray());
            attr = new BasicAttribute("m-bytecode", bytecode);
        }
        return this.getSyntaxChecker(syntaxCheckerDescription.getNumericOid(), syntaxCheckerDescription.getFqcn(), attr, targetRegistries);
    }

    private Comparator getComparator(String className, Attribute bytecode, Registries targetRegistries) throws NamingException {
        Comparator comparator = null;
        Class<?> clazz = null;
        if (bytecode == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LdapNamingException ne = new LdapNamingException("Comparator class " + className + " was not found", ResultCodeEnum.OTHER);
                ne.setRootCause((Throwable)e);
                throw ne;
            }
        }
        this.classLoader.setAttribute(bytecode);
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LdapNamingException ne = new LdapNamingException("Comparator class " + className + " was not found", ResultCodeEnum.OTHER);
            ne.setRootCause((Throwable)e);
            throw ne;
        }
        try {
            comparator = (Comparator)clazz.newInstance();
        }
        catch (InstantiationException e) {
            NamingException ne = new NamingException("Failed to instantiate comparator class " + className + ".\nCheck that a default constructor exists for the class.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("Failed to instantiate comparator class " + className + ".\nCheck that a **PUBLIC** accessible default constructor exists for the class.");
            ne.setRootCause(e);
            throw ne;
        }
        this.injectRegistries(comparator, targetRegistries);
        return comparator;
    }

    public Comparator getComparator(ComparatorDescription comparatorDescription, Registries targetRegistries) throws NamingException {
        BasicAttribute attr = null;
        if (comparatorDescription.getBytecode() != null) {
            byte[] bytecode = Base64.decode((char[])comparatorDescription.getBytecode().toCharArray());
            attr = new BasicAttribute("m-bytecode", bytecode);
        }
        return this.getComparator(comparatorDescription.getFqcn(), attr, targetRegistries);
    }

    public Comparator getComparator(Attributes entry, Registries targetRegistries) throws NamingException {
        if (entry == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (entry.get("m-fqcn") == null) {
            throw new NullPointerException("entry must have a valid m-fqcn attribute");
        }
        String className = (String)entry.get("m-fqcn").get();
        return this.getComparator(className, entry.get("m-bytecode"), targetRegistries);
    }

    private Normalizer getNormalizer(String className, Attribute bytecode, Registries targetRegistries) throws NamingException {
        Class<?> clazz = null;
        Normalizer normalizer = null;
        try {
            if (bytecode == null) {
                clazz = Class.forName(className);
            } else {
                this.classLoader.setAttribute(bytecode);
                clazz = this.classLoader.loadClass(className);
            }
        }
        catch (ClassNotFoundException e) {
            LdapNamingException ne = new LdapNamingException("Normalizer class " + className + " was not found", ResultCodeEnum.OTHER);
            ne.setRootCause((Throwable)e);
            throw ne;
        }
        try {
            normalizer = (Normalizer)clazz.newInstance();
        }
        catch (InstantiationException e) {
            LdapNamingException ne = new LdapNamingException("Failed to instantiate normalizer class " + className + ".\nCheck that a default constructor exists for the class.", ResultCodeEnum.OTHER);
            ne.setRootCause((Throwable)e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            LdapNamingException ne = new LdapNamingException("Failed to instantiate normalizer class " + className + ".\nCheck that a **PUBLIC** accessible default constructor exists for the class.", ResultCodeEnum.OTHER);
            ne.setRootCause((Throwable)e);
            throw ne;
        }
        this.injectRegistries(normalizer, targetRegistries);
        return normalizer;
    }

    public Normalizer getNormalizer(NormalizerDescription normalizerDescription, Registries targetRegistries) throws NamingException {
        BasicAttribute attr = null;
        if (normalizerDescription.getBytecode() != null) {
            byte[] bytecode = Base64.decode((char[])normalizerDescription.getBytecode().toCharArray());
            attr = new BasicAttribute("m-bytecode", bytecode);
        }
        return this.getNormalizer(normalizerDescription.getFqcn(), attr, targetRegistries);
    }

    public Normalizer getNormalizer(Attributes entry, Registries targetRegistries) throws NamingException {
        if (entry == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (entry.get("m-fqcn") == null) {
            throw new NullPointerException("entry must have a valid m-fqcn attribute");
        }
        String className = (String)entry.get("m-fqcn").get();
        return this.getNormalizer(className, entry.get("m-bytecode"), targetRegistries);
    }

    private void injectRegistries(Object obj, Registries targetRegistries) throws NamingException {
        String className = obj.getClass().getName();
        try {
            Method method = obj.getClass().getMethod("setRegistries", parameterTypes);
            if (method == null) {
                return;
            }
            Object[] args = new Object[]{this.bootstrapRegistries};
            method.invoke(obj, args);
        }
        catch (SecurityException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (InvocationTargetException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
    }

    private void injectOid(String syntaxOid, SyntaxChecker checker) throws NamingException {
        String className = checker.getClass().getName();
        try {
            Method method = checker.getClass().getMethod("setSyntaxOid", setOidParameterTypes);
            if (method == null) {
                return;
            }
            Object[] args = new Object[]{syntaxOid};
            method.invoke((Object)checker, args);
        }
        catch (SecurityException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the oid dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the oid dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the oid dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (InvocationTargetException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the oid dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
    }

    public Syntax getSyntax(Attributes entry, Registries targetRegistries, String schema) throws NamingException {
        String oid = (String)entry.get("m-oid").get();
        SyntaxImpl syntax = new SyntaxImpl(oid, targetRegistries.getSyntaxCheckerRegistry());
        syntax.setSchema(schema);
        if (entry.get("x-humanReadable") != null) {
            String val = (String)entry.get("x-humanReadable").get();
            syntax.setHumanReadable(val.toUpperCase().equals("TRUE"));
        }
        if (entry.get("m-description") != null) {
            syntax.setDescription((String)entry.get("m-description").get());
        }
        return syntax;
    }

    public MatchingRule getMatchingRule(Attributes entry, Registries targetRegistries, String schema) throws NamingException {
        String oid = (String)entry.get("m-oid").get();
        String syntaxOid = (String)entry.get("m-syntax").get();
        MatchingRuleImpl mr = new MatchingRuleImpl(oid, syntaxOid, targetRegistries);
        mr.setSchema(schema);
        this.setSchemaObjectProperties(mr, entry);
        return mr;
    }

    private String[] getStrings(Attribute attr) throws NamingException {
        if (attr == null) {
            return EMPTY;
        }
        String[] strings = new String[attr.size()];
        for (int ii = 0; ii < strings.length; ++ii) {
            strings[ii] = (String)attr.get(ii);
        }
        return strings;
    }

    public ObjectClass getObjectClass(Attributes entry, Registries targetRegistries, String schema) throws NamingException {
        String oid = (String)entry.get("m-oid").get();
        ObjectClassImpl oc = new ObjectClassImpl(oid, targetRegistries);
        oc.setSchema(schema);
        if (entry.get("m-supObjectClass") != null) {
            oc.setSuperClassOids(this.getStrings(entry.get("m-supObjectClass")));
        }
        if (entry.get("m-may") != null) {
            oc.setMayListOids(this.getStrings(entry.get("m-may")));
        }
        if (entry.get("m-must") != null) {
            oc.setMustListOids(this.getStrings(entry.get("m-must")));
        }
        if (entry.get("m-typeObjectClass") != null) {
            String type = (String)entry.get("m-typeObjectClass").get();
            oc.setType(ObjectClassTypeEnum.getClassType((String)type));
        } else {
            oc.setType(ObjectClassTypeEnum.STRUCTURAL);
        }
        this.setSchemaObjectProperties(oc, entry);
        return oc;
    }

    public AttributeType getAttributeType(Attributes entry, Registries targetRegistries, String schema) throws NamingException {
        String val;
        String oid = (String)entry.get("m-oid").get();
        AttributeTypeImpl at = new AttributeTypeImpl(oid, targetRegistries);
        at.setSchema(schema);
        this.setSchemaObjectProperties(at, entry);
        if (entry.get("m-syntax") != null) {
            at.setSyntaxOid((String)entry.get("m-syntax").get());
        }
        if (entry.get("m-equality") != null) {
            at.setEqualityOid((String)entry.get("m-equality").get());
        }
        if (entry.get("m-ordering") != null) {
            at.setOrderingOid((String)entry.get("m-ordering").get());
        }
        if (entry.get("m-substr") != null) {
            at.setSubstrOid((String)entry.get("m-substr").get());
        }
        if (entry.get("m-supAttributeType") != null) {
            at.setSuperiorOid((String)entry.get("m-supAttributeType").get());
        }
        if (entry.get("m-collective") != null) {
            val = (String)entry.get("m-collective").get();
            at.setCollective(val.equalsIgnoreCase("TRUE"));
        }
        if (entry.get("m-singleValue") != null) {
            val = (String)entry.get("m-singleValue").get();
            at.setSingleValue(val.equalsIgnoreCase("TRUE"));
        }
        if (entry.get("m-noUserModification") != null) {
            val = (String)entry.get("m-noUserModification").get();
            at.setCanUserModify(!val.equalsIgnoreCase("TRUE"));
        }
        if (entry.get("m-usage") != null) {
            at.setUsage(UsageEnum.getUsage((String)((String)entry.get("m-usage").get())));
        }
        return at;
    }

    private void setSchemaObjectProperties(MutableSchemaObject mso, Attributes entry) throws NamingException {
        Attribute names;
        if (entry.get("m-obsolete") != null) {
            String val = (String)entry.get("m-obsolete").get();
            mso.setObsolete(val.equalsIgnoreCase("TRUE"));
        }
        if (entry.get("m-description") != null) {
            mso.setDescription((String)entry.get("m-description").get());
        }
        if ((names = entry.get("m-name")) != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (int ii = 0; ii < names.size(); ++ii) {
                values.add((String)names.get(ii));
            }
            mso.setNames(values.toArray(EMPTY));
        }
    }
}

