/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import org.javasimon.AbstractSimon;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Manager;
import org.javasimon.utils.SimonUtils;

final class CounterImpl
extends AbstractSimon
implements Counter {
    private long counter;
    private long incrementSum;
    private long decrementSum;
    private long max = Long.MIN_VALUE;
    private long maxTimestamp;
    private long min = Long.MAX_VALUE;
    private long minTimestamp;

    CounterImpl(String name, Manager manager) {
        super(name, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter set(long val) {
        long now = System.currentTimeMillis();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            Counter counter;
            try {
                counter = this.privateSet(val, now);
                this.manager.callback().counterSet(this, val);
            }
            catch (Throwable throwable) {
                this.manager.callback().counterSet(this, val);
                throw throwable;
            }
            return counter;
        }
    }

    private Counter privateSet(long val, long now) {
        this.updateUsages(now);
        this.counter = val;
        if (this.counter >= this.max) {
            this.max = this.counter;
            this.maxTimestamp = this.getLastUsage();
        }
        if (this.counter <= this.min) {
            this.min = this.counter;
            this.minTimestamp = this.getLastUsage();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter increase() {
        long now = System.currentTimeMillis();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            CounterImpl counterImpl2;
            try {
                this.updateUsages(now);
                ++this.counter;
                ++this.incrementSum;
                if (this.counter >= this.max) {
                    this.max = this.counter;
                    this.maxTimestamp = this.getLastUsage();
                }
                counterImpl2 = this;
                this.manager.callback().counterIncrease(this, 1L);
            }
            catch (Throwable throwable) {
                this.manager.callback().counterIncrease(this, 1L);
                throw throwable;
            }
            return counterImpl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter decrease() {
        long now = System.currentTimeMillis();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            CounterImpl counterImpl2;
            try {
                this.updateUsages(now);
                --this.counter;
                ++this.decrementSum;
                if (this.counter <= this.min) {
                    this.min = this.counter;
                    this.minTimestamp = this.getLastUsage();
                }
                counterImpl2 = this;
                this.manager.callback().counterDecrease(this, 1L);
            }
            catch (Throwable throwable) {
                this.manager.callback().counterDecrease(this, 1L);
                throw throwable;
            }
            return counterImpl2;
        }
    }

    private void updateUsages(long now) {
        this.lastUsage = now;
        if (this.firstUsage == 0L) {
            this.firstUsage = this.lastUsage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Counter increase(long inc) {
        long now = System.currentTimeMillis();
        CounterImpl counterImpl = this;
        synchronized (counterImpl) {
            Counter counter;
            try {
                this.incrementSum += inc;
                counter = this.privateSet(this.counter + inc, now);
                this.manager.callback().counterIncrease(this, inc);
            }
            catch (Throwable throwable) {
                this.manager.callback().counterIncrease(this, inc);
                throw throwable;
            }
            return counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Counter decrease(long dec) {
        try {
            this.decrementSum -= dec;
            Counter counter = this.set(this.counter - dec);
            return counter;
        }
        finally {
            this.manager.callback().counterDecrease(this, dec);
        }
    }

    public synchronized Counter reset() {
        this.counter = 0L;
        this.max = Long.MIN_VALUE;
        this.maxTimestamp = 0L;
        this.min = Long.MAX_VALUE;
        this.minTimestamp = 0L;
        this.incrementSum = 0L;
        this.decrementSum = 0L;
        this.saveResetTimestamp();
        this.manager.callback().reset(this);
        return this;
    }

    public synchronized CounterSample sampleAndReset() {
        CounterSample sample = this.sample();
        this.reset();
        return sample;
    }

    public synchronized CounterSample sample() {
        CounterSample sample = new CounterSample();
        sample.setCounter(this.counter);
        sample.setMin(this.min);
        sample.setMax(this.max);
        sample.setMinTimestamp(this.minTimestamp);
        sample.setMaxTimestamp(this.maxTimestamp);
        sample.setIncrementSum(this.incrementSum);
        sample.setDecrementSum(this.decrementSum);
        this.sampleCommon(sample);
        return sample;
    }

    public synchronized long getCounter() {
        return this.counter;
    }

    public synchronized long getMin() {
        return this.min;
    }

    public synchronized long getMinTimestamp() {
        return this.minTimestamp;
    }

    public synchronized long getMax() {
        return this.max;
    }

    public synchronized long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getIncrementSum() {
        return this.incrementSum;
    }

    public long getDecrementSum() {
        return this.decrementSum;
    }

    public String toString() {
        return "Simon Counter: " + super.toString() + " counter=" + this.counter + ", max=" + SimonUtils.presentMinMaxCount(this.max) + ", min=" + SimonUtils.presentMinMaxCount(this.min) + (this.getNote() != null && this.getNote().length() != 0 ? ", note '" + this.getNote() + "'" : "");
    }
}

