/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.onlyoffice.automation;

import fr.toutatice.ecm.platform.core.edition.CurrentlyEditedCacheHelper;
import java.util.HashMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Document.IsDocumentCurrentlyEdited", category="Document", label="Is document currently edited in only office ?", description="Return true if document is currently edited and by whom")
public class IsDocumentCurrentlyEdited {
    public static final String ID = "Document.IsDocumentCurrentlyEdited";
    private static final Log log = LogFactory.getLog(IsDocumentCurrentlyEdited.class);
    @Context
    protected CoreSession coreSession;
    @Param(name="id")
    protected DocumentModel currentDocument;

    @OperationMethod
    public Object run() throws Exception {
        JSONArray json = new JSONArray();
        HashMap<String, Boolean> infos = null;
        JSONObject cacheEntry = CurrentlyEditedCacheHelper.get((DocumentModel)this.currentDocument);
        if (cacheEntry != null) {
            infos = new HashMap<String, Boolean>(2);
            infos.put("isCurrentlyEdited", true);
            infos.put("currentlyEditedEntry", (Boolean)cacheEntry);
            json.add(infos);
        } else {
            infos = new HashMap(1);
            infos.put("isCurrentlyEdited", false);
            json.add(infos);
        }
        return new StringBlob(json.toString(), "application/json");
    }
}

