/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nuxeo.common.xmap.XAccessor;

public class XMethodAccessor
implements XAccessor {
    private final Method setter;
    private final Class klass;
    Method getter;

    public XMethodAccessor(Method method, Class klass) {
        this.setter = method;
        this.setter.setAccessible(true);
        this.klass = klass;
    }

    @Override
    public Class getType() {
        return this.setter.getParameterTypes()[0];
    }

    @Override
    public void setValue(Object instance, Object value) {
        try {
            this.setter.invoke(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return "XMethodSetter {method: " + this.setter + '}';
    }

    @Override
    public Object getValue(Object instance) {
        if (this.getter == null) {
            this.getter = this.findGetter(this.klass);
        }
        if (this.getter != null) {
            try {
                return this.getter.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    private Method findGetter(Class klass) {
        String setterName = this.setter.getName();
        if (setterName.toLowerCase().startsWith("set")) {
            String suffix = setterName.substring(3);
            String prefix = null;
            Class<?>[] classes = this.setter.getParameterTypes();
            Class<?> clazz = classes[0];
            prefix = clazz == Boolean.class || clazz == Boolean.TYPE ? "is" : "get";
            String getterName = prefix + suffix;
            try {
                return klass.getMethod(getterName, new Class[0]);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("there is NO getter defined for annotated setter: " + setterName, e);
            }
        }
        return null;
    }
}

