/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.tag.web.TagActionsBean;
import org.nuxeo.ecm.platform.ui.select2.common.Select2Common;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="tagSelect2Support")
@Scope(value=ScopeType.EVENT)
public class TagSelect2Support {
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true, value="currentDocumentTags")
    protected List<Tag> currentDocumentTags;
    protected String label;

    @Factory(value="resolveDocumentTags", scope=ScopeType.EVENT)
    public String resolveDocumentTags() throws ClientException {
        if (this.currentDocumentTags == null || this.currentDocumentTags.isEmpty()) {
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (Tag tag : this.currentDocumentTags) {
            JSONObject obj = new JSONObject();
            obj.element("id", (Object)tag.getLabel());
            obj.element("displayLabel", (Object)tag.getLabel());
            result.add((Object)obj);
        }
        return result.toString();
    }

    public String resolveTags(List<String> list) {
        return Select2Common.resolveDefaultEntries(list);
    }

    public String resolveTags(String[] array) {
        if (array == null || array.length == 0) {
            return Select2Common.resolveDefaultEntries(null);
        }
        return Select2Common.resolveDefaultEntries(Arrays.asList(array));
    }

    @Factory(value="documentTagIds", scope=ScopeType.EVENT)
    public List<String> getDocumentTagStrings() throws ClientException {
        if (this.currentDocumentTags == null || this.currentDocumentTags.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Tag tag : this.currentDocumentTags) {
            result.add(tag.getLabel());
        }
        return result;
    }

    public String addTagging() throws ClientException {
        String messageKey;
        if (StringUtils.isBlank((String)this.label)) {
            messageKey = "message.add.new.tagging.not.empty";
        } else {
            DocumentRef ref;
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            String docId = currentDocument.getId();
            TagService tagService = this.getTagService();
            tagService.tag(this.documentManager, docId, this.label, null);
            if (currentDocument.isVersion()) {
                DocumentModel liveDocument = this.documentManager.getSourceDocument(currentDocument.getRef());
                if (!liveDocument.isCheckedOut()) {
                    tagService.tag(this.documentManager, liveDocument.getId(), this.label, null);
                }
            } else if (!currentDocument.isCheckedOut() && (ref = this.documentManager.getBaseVersion(currentDocument.getRef())) instanceof IdRef) {
                tagService.tag(this.documentManager, ref.toString(), this.label, null);
            }
            messageKey = "message.add.new.tagging";
            Contexts.getEventContext().remove("resolveDocumentTags");
        }
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get(messageKey), new Object[]{this.label});
        this.reset();
        return null;
    }

    public String removeTagging() throws ClientException {
        DocumentRef ref;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String docId = currentDocument.getId();
        TagService tagService = this.getTagService();
        tagService.untag(this.documentManager, docId, this.label, null);
        if (currentDocument.isVersion()) {
            DocumentModel liveDocument = this.documentManager.getSourceDocument(currentDocument.getRef());
            if (!liveDocument.isCheckedOut()) {
                tagService.untag(this.documentManager, liveDocument.getId(), this.label, null);
            }
        } else if (!currentDocument.isCheckedOut() && (ref = this.documentManager.getBaseVersion(currentDocument.getRef())) instanceof IdRef) {
            tagService.untag(this.documentManager, ref.toString(), this.label, null);
        }
        Contexts.getEventContext().remove("currentDocumentTags");
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("message.remove.tagging"), new Object[]{this.label});
        this.reset();
        return null;
    }

    protected void reset() {
        this.label = null;
    }

    protected TagService getTagService() throws ClientException {
        TagService tagService;
        try {
            tagService = (TagService)Framework.getService(TagService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        if (tagService == null) {
            return null;
        }
        return tagService.isEnabled() ? tagService : null;
    }

    public String encodeParameters(Map<String, Serializable> widgetProperties) {
        return this.encodeCommonParameters(widgetProperties).toString();
    }

    public String encodeParametersForCurrentDocument(Map<String, Serializable> widgetProperties) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("onAddEntryHandler", "addTagHandler");
        parameters.put("onRemoveEntryHandler", "removeTagHandler");
        parameters.put("containerCssClass", "s2tagContainerCssClass");
        parameters.put("dropdownCssClass", "s2tagDropdownCssClass");
        parameters.put("createSearchChoice", "createNewTag");
        if (widgetProperties.containsKey("canSelectNewTag") && !Boolean.parseBoolean((String)((Object)widgetProperties.get("canSelectNewTag")))) {
            parameters.remove("createSearchChoice");
        }
        return this.encodeCommonParameters(widgetProperties, parameters).toString();
    }

    protected JSONObject encodeCommonParameters(Map<String, Serializable> widgetProperties) {
        return this.encodeCommonParameters(widgetProperties, null);
    }

    protected JSONObject encodeCommonParameters(Map<String, Serializable> widgetProperties, Map<String, String> additionalParameters) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"multiple", (Object)"true");
        obj.put((Object)"minChars", (Object)"1");
        obj.put((Object)"readonly", (Object)"false");
        if (widgetProperties.containsKey("canSelectNewTag") && Boolean.parseBoolean((String)((Object)widgetProperties.get("canSelectNewTag")))) {
            obj.put((Object)"createSearchChoice", (Object)"createNewTag");
        }
        obj.put((Object)"operationId", (Object)"Tag.Suggestion");
        obj.put((Object)"width", (Object)"300px");
        obj.put((Object)"selectionFormatter", (Object)"formatSelectedTags");
        obj.put((Object)"suggestionFormatter", (Object)"formatSuggestedTags");
        JSONArray tokenSeparator = new JSONArray();
        tokenSeparator.add((Object)",");
        tokenSeparator.add((Object)" ");
        obj.put((Object)"tokenSeparators", (Object)tokenSeparator);
        if (additionalParameters != null) {
            for (Map.Entry<String, Object> entry : additionalParameters.entrySet()) {
                obj.put((Object)entry.getKey(), (Object)((String)entry.getValue()).toString());
            }
        }
        for (Map.Entry<String, Object> entry : widgetProperties.entrySet()) {
            obj.put((Object)entry.getKey(), (Object)((Serializable)entry.getValue()).toString());
        }
        return obj;
    }

    public void listDocumentsForTag() throws ClientException {
        TagActionsBean tagActionsBean = (TagActionsBean)Component.getInstance(TagActionsBean.class);
        tagActionsBean.setListLabel(this.label);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

