/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.Heap;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;

public class VarOrderHeap
implements IOrder,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double VAR_RESCALE_FACTOR = 1.0E-100;
    private static final double VAR_RESCALE_BOUND = 1.0E100;
    protected double[] activity = new double[1];
    private double varDecay = 1.0;
    private double varInc = 1.0;
    protected ILits lits;
    private long nullchoice = 0L;
    protected Heap heap;
    protected IPhaseSelectionStrategy phaseStrategy;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.orders.VarOrderHeap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public VarOrderHeap() {
        this(new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public VarOrderHeap(IPhaseSelectionStrategy strategy) {
        this.phaseStrategy = strategy;
    }

    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy strategy) {
        this.phaseStrategy = strategy;
    }

    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.phaseStrategy;
    }

    public void setLits(ILits lits) {
        this.lits = lits;
    }

    public int select() {
        while (!this.heap.empty()) {
            int var = this.heap.getmin();
            int next = this.phaseStrategy.select(var);
            if (!this.lits.isUnassigned(next)) continue;
            if (this.activity[var] < 1.0E-4) {
                ++this.nullchoice;
            }
            return next;
        }
        return -1;
    }

    public void setVarDecay(double d) {
        this.varDecay = d;
    }

    public void undo(int x) {
        if (!this.heap.inHeap(x)) {
            this.heap.insert(x);
        }
    }

    public void updateVar(int p) {
        int var = LiteralsUtils.var(p);
        this.updateActivity(var);
        this.phaseStrategy.updateVar(p);
        if (this.heap.inHeap(var)) {
            this.heap.increase(var);
        }
    }

    protected void updateActivity(int var) {
        int n = var;
        double d = this.activity[n] = this.activity[n] + this.varInc;
        if (d > 1.0E100) {
            this.varRescaleActivity();
        }
    }

    public void varDecayActivity() {
        this.varInc *= this.varDecay;
    }

    private void varRescaleActivity() {
        int i = 1;
        while (i < this.activity.length) {
            int n = i++;
            this.activity[n] = this.activity[n] * 1.0E-100;
        }
        this.varInc *= 1.0E-100;
    }

    public double varActivity(int p) {
        return this.activity[LiteralsUtils.var(p)];
    }

    public int numberOfInterestingVariables() {
        int cpt = 0;
        int i = 1;
        while (i < this.activity.length) {
            if (this.activity[i] > 1.0) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public void init() {
        int nlength = this.lits.nVars() + 1;
        if (this.activity == null || this.activity.length < nlength) {
            this.activity = new double[nlength];
        }
        this.phaseStrategy.init(nlength);
        this.activity[0] = -1.0;
        this.heap = new Heap(this.activity);
        this.heap.setBounds(nlength);
        int i = 1;
        while (i < nlength) {
            if (!$assertionsDisabled && i <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && i > this.lits.nVars()) {
                throw new AssertionError((Object)(this.lits.nVars() + "/" + i));
            }
            this.activity[i] = 0.0;
            if (this.lits.belongsToPool(i)) {
                this.heap.insert(i);
            }
            ++i;
        }
    }

    public String toString() {
        return "VSIDS like heuristics from MiniSAT using a heap " + this.phaseStrategy;
    }

    public ILits getVocabulary() {
        return this.lits;
    }

    public void printStat(PrintWriter out, String prefix) {
        out.println(String.valueOf(prefix) + "non guided choices\t" + this.nullchoice);
    }

    public void assignLiteral(int p) {
    }

    public void updateVarAtDecisionLevel(int q) {
        this.phaseStrategy.updateVarAtDecisionLevel(q);
    }
}

