/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management;

import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.GlobalAdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.ProbeManager;
import org.nuxeo.ecm.core.management.events.EventStatsHolder;
import org.nuxeo.ecm.core.management.events.EventStatsImpl;
import org.nuxeo.ecm.core.management.probes.ProbeDescriptor;
import org.nuxeo.ecm.core.management.probes.ProbeManagerImpl;
import org.nuxeo.ecm.core.management.statuses.AdministrableServiceDescriptor;
import org.nuxeo.ecm.core.management.statuses.AdministrativeStatusManagerImpl;
import org.nuxeo.ecm.core.management.statuses.GlobalAdministrativeStatusManagerImpl;
import org.nuxeo.ecm.core.management.storage.DocumentStoreConfigurationDescriptor;
import org.nuxeo.ecm.core.management.storage.DocumentStoreHandlerDescriptor;
import org.nuxeo.ecm.core.management.storage.DocumentStoreManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class CoreManagementComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(CoreManagementComponent.class.getCanonicalName());
    public static final String PROBES_EP = "probes";
    public static final String SERVICE_DEF_EP = "serviceDefinition";
    public static final String STORAGE_HANDLERS_EP = "storageHandlers";
    public static final String STORAGE_CONFIG_EP = "storageConfiguration";
    protected static CoreManagementComponent defaultComponent;
    protected final GlobalAdministrativeStatusManager globalManager = new GlobalAdministrativeStatusManagerImpl();
    protected final EventStats eventStats = new EventStatsImpl();
    protected final ProbeManagerImpl probeRunner = new ProbeManagerImpl();
    protected final DocumentStoreManager storageManager = new DocumentStoreManager();

    public AdministrativeStatusManagerImpl getLocalManager() {
        return (AdministrativeStatusManagerImpl)this.globalManager.getStatusManager(this.globalManager.getLocalNuxeoInstanceIdentifier());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == EventStats.class) {
            return adapter.cast(this.eventStats);
        }
        if (adapter.isAssignableFrom(GlobalAdministrativeStatusManager.class)) {
            return adapter.cast(this.globalManager);
        }
        if (adapter.isAssignableFrom(AdministrativeStatusManager.class)) {
            return adapter.cast(this.getLocalManager());
        }
        if (adapter.isAssignableFrom(ProbeManager.class)) {
            return adapter.cast(this.probeRunner);
        }
        return (T)super.getAdapter(adapter);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(PROBES_EP)) {
            this.probeRunner.registerProbe((ProbeDescriptor)contribution);
        } else if (extensionPoint.equals(SERVICE_DEF_EP)) {
            this.globalManager.registerService((AdministrableServiceDescriptor)contribution);
        } else if (extensionPoint.equals(STORAGE_HANDLERS_EP)) {
            this.storageManager.registerHandler((DocumentStoreHandlerDescriptor)contribution);
        } else if (extensionPoint.equals(STORAGE_CONFIG_EP)) {
            this.storageManager.registerConfig((DocumentStoreConfigurationDescriptor)contribution);
        } else {
            super.registerContribution(contribution, extensionPoint, contributor);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(PROBES_EP)) {
            this.probeRunner.unregisterProbe((ProbeDescriptor)contribution);
        }
    }

    public static CoreManagementComponent getDefault() {
        return defaultComponent;
    }

    public void activate(ComponentContext context) throws Exception {
        defaultComponent = this;
        this.storageManager.install();
        EventStatsHolder.clearStats();
    }

    public void deactivate(ComponentContext context) throws Exception {
        defaultComponent = null;
        this.storageManager.uninstall();
        this.getLocalManager().onNuxeoServerShutdown();
        EventStatsHolder.clearStats();
    }

    public void onNuxeoServerStartup() {
        this.getLocalManager().onNuxeoServerStartup();
    }
}

